/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.ForClauseOuterPull;
import net.sf.saxon.expr.flwor.ForClauseOuterPush;
import net.sf.saxon.expr.flwor.ForClausePull;
import net.sf.saxon.expr.flwor.ForClausePush;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForClause
extends Clause {
    private LocalVariableBinding rangeVariable;
    private LocalVariableBinding positionVariable;
    private Expression sequence;
    private boolean allowsEmpty;

    @Override
    public int getClauseKey() {
        return 0;
    }

    @Override
    public ForClause copy() {
        ForClause f2 = new ForClause();
        f2.setLocationId(this.getLocationId());
        f2.rangeVariable = this.rangeVariable.copy();
        if (this.positionVariable != null) {
            f2.positionVariable = this.positionVariable.copy();
        }
        f2.sequence = this.sequence.copy();
        f2.allowsEmpty = this.allowsEmpty;
        return f2;
    }

    public void setSequence(Expression sequence) {
        this.sequence = sequence;
    }

    public Expression getSequence() {
        return this.sequence;
    }

    public void setRangeVariable(LocalVariableBinding binding) {
        this.rangeVariable = binding;
    }

    public LocalVariableBinding getRangeVariable() {
        return this.rangeVariable;
    }

    public void setPositionVariable(LocalVariableBinding binding) {
        this.positionVariable = binding;
    }

    public LocalVariableBinding getPositionVariable() {
        return this.positionVariable;
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        if (this.positionVariable == null) {
            return new LocalVariableBinding[]{this.rangeVariable};
        }
        return new LocalVariableBinding[]{this.rangeVariable, this.positionVariable};
    }

    public void setAllowingEmpty(boolean option) {
        this.allowsEmpty = option;
    }

    public boolean isAllowingEmpty() {
        return this.allowsEmpty;
    }

    @Override
    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        SequenceType decl = this.rangeVariable.getRequiredType();
        SequenceType sequenceType = SequenceType.makeSequenceType(decl.getPrimaryType(), 57344);
        RoleLocator role = new RoleLocator(3, this.rangeVariable.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType, role, visitor.getStaticContext());
    }

    @Override
    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        if (this.allowsEmpty) {
            return new ForClauseOuterPull(base, this);
        }
        return new ForClausePull(base, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        if (this.allowsEmpty) {
            return new ForClauseOuterPush(destination, this);
        }
        return new ForClausePush(destination, this);
    }

    public boolean addPredicate(FLWORExpression flwor, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType, Expression condition) throws XPathException {
        Binding[] thisVar;
        ItemType selectionContextItemType;
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        boolean debug = opt.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/trace-optimizer-decisions");
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression head = null;
        Expression selection = this.sequence;
        ItemType itemType = selectionContextItemType = contextItemType == null ? null : contextItemType.getItemType();
        if (this.sequence instanceof SlashExpression) {
            if (((SlashExpression)this.sequence).isAbsolute(th)) {
                head = ((SlashExpression)this.sequence).getFirstStep();
                selection = ((SlashExpression)this.sequence).getRemainingSteps();
                selectionContextItemType = head.getItemType();
            } else {
                SlashExpression p = ((SlashExpression)this.sequence).tryToMakeAbsolute(th);
                if (p != null) {
                    this.sequence = p;
                    head = ((SlashExpression)this.sequence).getFirstStep();
                    selection = ((SlashExpression)this.sequence).getRemainingSteps();
                    selectionContextItemType = head.getItemType();
                }
            }
        }
        boolean changed = false;
        if (this.positionVariable != null && (condition instanceof ValueComparison || condition instanceof GeneralComparison || condition instanceof CompareToIntegerConstant) && ExpressionTool.dependsOnVariable(condition, new Binding[]{this.positionVariable})) {
            ComparisonExpression comp = (ComparisonExpression)((Object)condition);
            Expression[] operands = comp.getOperands();
            if (ExpressionTool.dependsOnVariable(flwor, new Binding[]{this.positionVariable})) {
                return false;
            }
            for (int op = 0; op < 2; ++op) {
                Binding[] thisVar2 = new Binding[]{this.getRangeVariable()};
                if (this.positionVariable == null || !(operands[op] instanceof VariableReference) || changed) continue;
                ArrayList<VariableReference> varRefs = new ArrayList<VariableReference>();
                ExpressionTool.gatherVariableReferences(condition, this.positionVariable, varRefs);
                if (varRefs.size() != 1 || varRefs.get(0) != operands[op] || ExpressionTool.dependsOnFocus(operands[1 - op]) || ExpressionTool.dependsOnVariable(operands[1 - op], thisVar2)) continue;
                FunctionCall position = SystemFunctionCall.makeSystemFunction("position", SimpleExpression.NO_ARGUMENTS);
                Expression predicate = condition.copy();
                predicate.replaceOperand(((ComparisonExpression)((Object)predicate)).getOperands()[op], position);
                if (debug) {
                    opt.trace("Replaced positional variable in predicate by position()");
                }
                selection = new FilterExpression(selection, predicate);
                ExpressionTool.copyLocationInfo(predicate, selection);
                ContextItemStaticInfo cit = new ContextItemStaticInfo(selectionContextItemType, true);
                selection = visitor.typeCheck(selection, cit);
                if (!ExpressionTool.dependsOnVariable(flwor, new Binding[]{this.positionVariable})) {
                    this.positionVariable = null;
                }
                changed = true;
                break;
            }
        }
        if (this.positionVariable == null && opt.isVariableReplaceableByDot(condition, thisVar = new Binding[]{this.getRangeVariable()})) {
            ContextItemExpression replacement = new ContextItemExpression();
            boolean found = ExpressionTool.inlineVariableReferences(condition, this.getRangeVariable(), replacement);
            if (found) {
                ContextItemStaticInfo cit = new ContextItemStaticInfo(this.sequence.getItemType(), true);
                Expression predicate = visitor.typeCheck(condition, cit);
                int rel = th.relationship(predicate.getItemType(), BuiltInAtomicType.INTEGER);
                if (rel != 4) {
                    predicate = SystemFunctionCall.makeSystemFunction("boolean", new Expression[]{predicate});
                    assert (predicate != null);
                }
                selection = new FilterExpression(selection, predicate);
                ExpressionTool.copyLocationInfo(predicate, selection);
                cit = new ContextItemStaticInfo(selectionContextItemType, true);
                selection = visitor.typeCheck(selection, cit);
                changed = true;
            }
        }
        if (changed) {
            if (head == null) {
                this.sequence = selection;
            } else if (head instanceof RootExpression && selection instanceof KeyFn) {
                this.sequence = selection;
            } else {
                Expression path = ExpressionTool.makePathExpression(head, selection, false);
                if (!(path instanceof SlashExpression)) {
                    return changed;
                }
                ExpressionTool.copyLocationInfo(condition, path);
                Expression k = visitor.getConfiguration().obtainOptimizer().convertPathExpressionToKey((SlashExpression)path, visitor);
                this.sequence = k == null ? path : k;
                this.sequence = visitor.optimize(visitor.typeCheck(visitor.simplify(this.sequence), contextItemType), contextItemType);
            }
        }
        return changed;
    }

    @Override
    public void processSubExpressions(ExpressionProcessor processor) throws XPathException {
        this.sequence = processor.processExpression(this.sequence);
    }

    public void gatherVariableReferences(List<VariableReference> references) {
        if (this.positionVariable != null) {
            ExpressionTool.gatherVariableReferences(this.sequence, this.positionVariable, references);
        }
        ExpressionTool.gatherVariableReferences(this.sequence, this.rangeVariable, references);
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor visitor, Binding binding, List<VariableReference> references) {
        ExpressionTool.gatherVariableReferences(this.sequence, binding, references);
    }

    @Override
    public void refineVariableType(ExpressionVisitor visitor, List<VariableReference> references, Expression returnExpr) {
        ItemType actualItemType = this.sequence.getItemType();
        if (actualItemType instanceof ErrorType) {
            actualItemType = AnyItemType.getInstance();
        }
        for (VariableReference ref : references) {
            ref.refineVariableType(actualItemType, this.allowsEmpty ? 24576 : 16384, null, this.sequence.getSpecialProperties(), visitor);
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("for");
        out.emitAttribute("var", this.getRangeVariable().getVariableQName().getDisplayName());
        out.emitAttribute("slot", this.getRangeVariable().getLocalSlotNumber() + "");
        LocalVariableBinding posVar = this.getPositionVariable();
        if (posVar != null) {
            out.emitAttribute("at", posVar.getVariableQName().getDisplayName());
            out.emitAttribute("at-slot", posVar.getLocalSlotNumber() + "");
        }
        this.sequence.explain(out);
        out.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append("for $");
        fsb.append(this.rangeVariable.getVariableQName().getDisplayName());
        fsb.append(' ');
        LocalVariableBinding posVar = this.getPositionVariable();
        if (posVar != null) {
            fsb.append("at $");
            fsb.append(posVar.getVariableQName().getDisplayName());
            fsb.append(' ');
        }
        fsb.append("in ");
        fsb.append(this.sequence.toString());
        return fsb.toString();
    }
}

