/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.oidc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.ClaimSetting;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.authc.support.SecuritySettingsUtil;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class OpenIdConnectRealmSettings {
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS = List.of("HS256", "HS384", "HS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "PS256", "PS384", "PS512");
    private static final List<String> RESPONSE_TYPES = List.of("code", "id_token", "id_token token");
    public static final List<String> CLIENT_AUTH_METHODS = List.of("client_secret_basic", "client_secret_post", "client_secret_jwt");
    public static final List<String> SUPPORTED_CLIENT_AUTH_JWT_ALGORITHMS = List.of("HS256", "HS384", "HS512");
    public static final String TYPE = "oidc";
    public static final Setting.AffixSetting<String> RP_CLIENT_ID = RealmSettings.simpleString("oidc", "rp.client_id", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<SecureString> RP_CLIENT_SECRET = RealmSettings.secureString("oidc", "rp.client_secret");
    public static final Setting.AffixSetting<String> RP_REDIRECT_URI = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "rp.redirect_uri", key -> Setting.simpleString(key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_POST_LOGOUT_REDIRECT_URI = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "rp.post_logout_redirect_uri", key -> Setting.simpleString(key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_RESPONSE_TYPE = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "rp.response_type", key -> Setting.simpleString(key, v -> {
        if (!RESPONSE_TYPES.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + String.valueOf(RESPONSE_TYPES));
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_SIGNATURE_ALGORITHM = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "rp.signature_algorithm", key -> new Setting<String>((String)key, "RS256", (Function<String, String>)Function.identity(), v -> {
        if (!SUPPORTED_SIGNATURE_ALGORITHMS.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + String.valueOf(SUPPORTED_SIGNATURE_ALGORITHMS) + "}]");
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> RP_REQUESTED_SCOPES = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "rp.requested_scopes", key -> Setting.stringListSetting(key, List.of("openid"), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_CLIENT_AUTH_METHOD = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "rp.client_auth_method", key -> new Setting<String>((String)key, "client_secret_basic", (Function<String, String>)Function.identity(), v -> {
        if (!CLIENT_AUTH_METHODS.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + String.valueOf(CLIENT_AUTH_METHODS) + "}]");
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> RP_CLIENT_AUTH_JWT_SIGNATURE_ALGORITHM = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "rp.client_auth_jwt_signature_algorithm", key -> new Setting<String>((String)key, "HS384", (Function<String, String>)Function.identity(), v -> {
        if (!SUPPORTED_CLIENT_AUTH_JWT_ALGORITHMS.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + String.valueOf(SUPPORTED_CLIENT_AUTH_JWT_ALGORITHMS) + "}]");
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_AUTHORIZATION_ENDPOINT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "op.authorization_endpoint", key -> Setting.simpleString(key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_TOKEN_ENDPOINT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "op.token_endpoint", key -> Setting.simpleString(key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_USERINFO_ENDPOINT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "op.userinfo_endpoint", key -> Setting.simpleString(key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_ENDSESSION_ENDPOINT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "op.endsession_endpoint", key -> Setting.simpleString(key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> OP_ISSUER = RealmSettings.simpleString("oidc", "op.issuer", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> OP_JWKSET_PATH = RealmSettings.simpleString("oidc", "op.jwkset_path", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<TimeValue> ALLOWED_CLOCK_SKEW = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "allowed_clock_skew", key -> Setting.timeSetting(key, TimeValue.timeValueSeconds(60L), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> POPULATE_USER_METADATA = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "populate_user_metadata", key -> Setting.boolSetting(key, true, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(5L);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECT_TIMEOUT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.connect_timeout", key -> Setting.timeSetting(key, DEFAULT_TIMEOUT, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECTION_READ_TIMEOUT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.connection_read_timeout", key -> Setting.timeSetting(key, DEFAULT_TIMEOUT, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_SOCKET_TIMEOUT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.socket_timeout", key -> Setting.timeSetting(key, DEFAULT_TIMEOUT, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_CONNECTIONS = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.max_connections", key -> Setting.intSetting(key, 200, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_ENDPOINT_CONNECTIONS = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.max_endpoint_connections", key -> Setting.intSetting(key, 200, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> HTTP_TCP_KEEP_ALIVE = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.tcp.keep_alive", key -> Setting.boolSetting(key, true, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECTION_POOL_TTL = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.connection_pool_ttl", key -> Setting.timeSetting(key, new TimeValue(3L, TimeUnit.MINUTES), Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> HTTP_PROXY_HOST = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.proxy.host", key -> Setting.simpleString(key, new Setting.Validator<String>(){

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            SecuritySettingsUtil.verifyProxySettings(key, value, settings, HTTP_PROXY_HOST, HTTP_PROXY_SCHEME, HTTP_PROXY_PORT);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            String namespace = HTTP_PROXY_HOST.getNamespace(HTTP_PROXY_HOST.getConcreteSetting(key));
            List<Setting<String>> settings = List.of(HTTP_PROXY_PORT.getConcreteSettingForNamespace(namespace), HTTP_PROXY_SCHEME.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_PROXY_PORT = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.proxy.port", key -> Setting.intSetting(key, 80, 1, 65535, Setting.Property.NodeScope), () -> HTTP_PROXY_HOST);
    public static final Setting.AffixSetting<String> HTTP_PROXY_SCHEME = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("oidc"), "http.proxy.scheme", key -> Setting.simpleString(key, "http", value -> {
        if (!value.equals("http") && !value.equals("https")) {
            throw new IllegalArgumentException("Invalid value [" + value + "] for [" + key + "]. Only `http` or `https` are allowed.");
        }
    }, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final ClaimSetting PRINCIPAL_CLAIM = new ClaimSetting("oidc", "principal");
    public static final ClaimSetting GROUPS_CLAIM = new ClaimSetting("oidc", "groups");
    public static final ClaimSetting NAME_CLAIM = new ClaimSetting("oidc", "name");
    public static final ClaimSetting DN_CLAIM = new ClaimSetting("oidc", "dn");
    public static final ClaimSetting MAIL_CLAIM = new ClaimSetting("oidc", "mail");

    private OpenIdConnectRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet<Setting.AffixSetting<?>> set = Sets.newHashSet(RP_CLIENT_ID, RP_REDIRECT_URI, RP_RESPONSE_TYPE, RP_REQUESTED_SCOPES, RP_CLIENT_SECRET, RP_SIGNATURE_ALGORITHM, RP_POST_LOGOUT_REDIRECT_URI, RP_CLIENT_AUTH_METHOD, RP_CLIENT_AUTH_JWT_SIGNATURE_ALGORITHM, OP_AUTHORIZATION_ENDPOINT, OP_TOKEN_ENDPOINT, OP_USERINFO_ENDPOINT, OP_ENDSESSION_ENDPOINT, OP_ISSUER, OP_JWKSET_PATH, POPULATE_USER_METADATA, HTTP_CONNECT_TIMEOUT, HTTP_CONNECTION_READ_TIMEOUT, HTTP_SOCKET_TIMEOUT, HTTP_MAX_CONNECTIONS, HTTP_MAX_ENDPOINT_CONNECTIONS, HTTP_TCP_KEEP_ALIVE, HTTP_CONNECTION_POOL_TTL, HTTP_PROXY_HOST, HTTP_PROXY_PORT, HTTP_PROXY_SCHEME, ALLOWED_CLOCK_SKEW);
        set.addAll(DelegatedAuthorizationSettings.getSettings(TYPE));
        set.addAll(RealmSettings.getStandardSettings(TYPE));
        set.addAll(SSLConfigurationSettings.getRealmSettings(TYPE));
        set.addAll(PRINCIPAL_CLAIM.settings());
        set.addAll(GROUPS_CLAIM.settings());
        set.addAll(DN_CLAIM.settings());
        set.addAll(NAME_CLAIM.settings());
        set.addAll(MAIL_CLAIM.settings());
        return set;
    }
}

