/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalMappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.xcontent.XContentBuilder;

public class SignificantStringTerms
extends InternalMappedSignificantTerms<SignificantStringTerms, Bucket> {
    public static final String NAME = "sigsterms";

    public SignificantStringTerms(String name, int requiredSize, long minDocCount, Map<String, Object> metadata, DocValueFormat format, long subsetSize, long supersetSize, SignificanceHeuristic significanceHeuristic, List<Bucket> buckets) {
        super(name, requiredSize, minDocCount, metadata, format, subsetSize, supersetSize, significanceHeuristic, buckets);
    }

    public SignificantStringTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public SignificantStringTerms create(List<Bucket> buckets) {
        return new SignificantStringTerms(this.name, this.requiredSize, this.minDocCount, (Map<String, Object>)this.metadata, this.format, this.subsetSize, this.supersetSize, this.significanceHeuristic, buckets);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, prototype.subsetDf, prototype.supersetDf, aggregations, prototype.format, prototype.score);
    }

    @Override
    protected SignificantStringTerms create(long subsetSize, long supersetSize, List<Bucket> buckets) {
        return new SignificantStringTerms(this.getName(), this.requiredSize, this.minDocCount, this.getMetadata(), this.format, subsetSize, supersetSize, this.significanceHeuristic, buckets);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    Bucket createBucket(long subsetDf, long supersetDf, InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, subsetDf, supersetDf, aggregations, this.format, prototype.score);
    }

    public static class Bucket
    extends InternalSignificantTerms.Bucket<Bucket> {
        BytesRef termBytes;

        public Bucket(BytesRef term, long subsetDf, long supersetDf, InternalAggregations aggregations, DocValueFormat format, double score) {
            super(subsetDf, supersetDf, aggregations, format);
            this.termBytes = term;
            this.score = score;
        }

        public Bucket(StreamInput in, DocValueFormat format) throws IOException {
            super(in, format);
            this.termBytes = in.readBytesRef();
            this.subsetDf = in.readVLong();
            this.supersetDf = in.readVLong();
            this.score = in.readDouble();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.termBytes);
            out.writeVLong(this.subsetDf);
            out.writeVLong(this.supersetDf);
            out.writeDouble(this.getSignificanceScore());
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.termBytes).toString();
        }

        @Override
        public String getKey() {
            return this.getKeyAsString();
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            return super.equals(obj) && Objects.equals(this.termBytes, ((Bucket)obj).termBytes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termBytes);
        }
    }
}

