/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.lucene.spatial.Component2DVisitor;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;

abstract class ShapeDocValuesQuery<GEOMETRY>
extends Query {
    private final String field;
    private final CoordinateEncoder encoder;
    private final ShapeField.QueryRelation relation;
    private final GEOMETRY[] geometries;

    ShapeDocValuesQuery(String field, CoordinateEncoder encoder, ShapeField.QueryRelation relation, GEOMETRY[] geometries) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.encoder = encoder;
        this.relation = relation;
        this.geometries = geometries;
    }

    protected abstract Component2D create(GEOMETRY var1);

    protected abstract Component2D create(GEOMETRY[] var1);

    protected void add(List<Component2D> components2D, GEOMETRY geometry) {
        components2D.add(this.create(geometry));
    }

    @Override
    public String toString(String otherField) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(otherField)) {
            sb.append(this.field);
            sb.append(':');
            sb.append((Object)this.relation);
            sb.append(':');
        }
        sb.append(Arrays.toString(this.geometries));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ShapeDocValuesQuery other = (ShapeDocValuesQuery)obj;
        return this.field.equals(other.field) && this.relation == other.relation && Arrays.equals(this.geometries, other.geometries);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + this.relation.hashCode();
        h = 31 * h + Arrays.hashCode(this.geometries);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) {
        if (this.relation == ShapeField.QueryRelation.CONTAINS) {
            return this.getContainsWeight(scoreMode, boost);
        }
        return this.getStandardWeight(scoreMode, boost);
    }

    private ConstantScoreWeight getStandardWeight(final ScoreMode scoreMode, float boost) {
        final Component2D component2D = this.create(this.geometries);
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return this.scorerSupplier(context).get(Long.MAX_VALUE);
            }

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) {
                final 1 weight = this;
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        final BinaryDocValues values = context.reader().getBinaryDocValues(ShapeDocValuesQuery.this.field);
                        if (values == null) {
                            return new ConstantScoreScorer(weight, 0.0f, scoreMode, DocIdSetIterator.empty());
                        }
                        final GeometryDocValueReader reader = new GeometryDocValueReader();
                        final Component2DVisitor visitor = Component2DVisitor.getVisitor(component2D, ShapeDocValuesQuery.this.relation, ShapeDocValuesQuery.this.encoder);
                        TwoPhaseIterator iterator = new TwoPhaseIterator(values){

                            @Override
                            public boolean matches() throws IOException {
                                reader.reset(values.binaryValue());
                                visitor.reset();
                                reader.visit(visitor);
                                return visitor.matches();
                            }

                            @Override
                            public float matchCost() {
                                return 1000.0f;
                            }
                        };
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                    }

                    @Override
                    public long cost() {
                        return context.reader().maxDoc();
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, ShapeDocValuesQuery.this.field);
            }
        };
    }

    private ConstantScoreWeight getContainsWeight(final ScoreMode scoreMode, float boost) {
        final ArrayList<Component2D> components2D = new ArrayList<Component2D>(this.geometries.length);
        for (GEOMETRY geometry : this.geometries) {
            this.add(components2D, geometry);
        }
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return this.scorerSupplier(context).get(Long.MAX_VALUE);
            }

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) {
                final 2 weight = this;
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        final BinaryDocValues values = context.reader().getBinaryDocValues(ShapeDocValuesQuery.this.field);
                        if (values == null) {
                            return new ConstantScoreScorer(weight, 0.0f, scoreMode, DocIdSetIterator.empty());
                        }
                        final Component2DVisitor[] visitors = new Component2DVisitor[components2D.size()];
                        for (int i = 0; i < components2D.size(); ++i) {
                            visitors[i] = Component2DVisitor.getVisitor((Component2D)components2D.get(i), ShapeDocValuesQuery.this.relation, ShapeDocValuesQuery.this.encoder);
                        }
                        final GeometryDocValueReader reader = new GeometryDocValueReader();
                        TwoPhaseIterator iterator = new TwoPhaseIterator(values){

                            @Override
                            public boolean matches() throws IOException {
                                reader.reset(values.binaryValue());
                                for (Component2DVisitor visitor : visitors) {
                                    visitor.reset();
                                    reader.visit(visitor);
                                    if (visitor.matches()) continue;
                                    return false;
                                }
                                return true;
                            }

                            @Override
                            public float matchCost() {
                                return 1000.0f;
                            }
                        };
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                    }

                    @Override
                    public long cost() {
                        return context.reader().maxDoc();
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, ShapeDocValuesQuery.this.field);
            }
        };
    }
}

