/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.internal.XPackLicenseStatus;

public class XPackLicenseState {
    static final Map<String, String[]> EXPIRATION_MESSAGES;
    static final Map<String, BiFunction<License.OperationMode, License.OperationMode, String[]>> ACKNOWLEDGMENT_MESSAGES;
    private final List<LicenseStateListener> listeners;
    private final Map<FeatureUsage, Long> usage;
    private final LongSupplier epochMillisProvider;
    private volatile XPackLicenseStatus xPackLicenseStatus;

    private static String[] securityAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: {
                        return new String[]{"Security tokens will not be supported."};
                    }
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Authentication will be limited to the native and file realms.", "Security tokens will not be supported.", "IP filtering and auditing will be disabled.", "Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
                break;
            }
            case GOLD: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: 
                    case BASIC: {
                        return new String[]{"Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
                break;
            }
            case STANDARD: {
                switch (currentMode) {
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: 
                    case BASIC: {
                        return new String[]{"Authentication will be limited to the native realms.", "IP filtering and auditing will be disabled.", "Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] watcherAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Watcher will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] monitoringAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{LoggerMessageFormat.format("Multi-cluster support is disabled for clusters with [{}] license. If you are\nrunning multiple clusters, users won't be able to access the clusters with\n[{}] licenses from within a single X-Pack Kibana instance. You will have to deploy a\nseparate and dedicated X-pack Kibana instance for each [{}] cluster you wish to monitor.", new Object[]{newMode, newMode, newMode})};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] graphAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Graph will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] enterpriseSearchAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case PLATINUM: {
                        return new String[]{"Search Applications and behavioral analytics will be disabled.", "Elastic Web crawler will be disabled.", "Connector clients require at least a platinum license."};
                    }
                    case TRIAL: 
                    case ENTERPRISE: {
                        return new String[]{"Search Applications and behavioral analytics will be disabled.", "Query rules will be disabled.", "Elastic Web crawler will be disabled.", "Connector clients require at least a platinum license."};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] esqlAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case PLATINUM: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case ENTERPRISE: {
                        return new String[]{"ES|QL cross-cluster search will be disabled."};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] machineLearningAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Machine learning will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] logstashAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                if (XPackLicenseState.isBasic(currentMode)) break;
                return new String[]{"Logstash will no longer poll for centrally-managed pipelines"};
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] beatsAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                if (XPackLicenseState.isBasic(currentMode)) break;
                return new String[]{"Beats will no longer be able to use centrally-managed configuration"};
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] sqlAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"JDBC and ODBC support will be disabled, but you can continue to use SQL CLI and REST endpoint"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] ccrAcknowledgementMessages(License.OperationMode current, License.OperationMode next) {
        switch (current) {
            case TRIAL: 
            case PLATINUM: 
            case ENTERPRISE: {
                switch (next) {
                    case STANDARD: 
                    case GOLD: 
                    case BASIC: 
                    case MISSING: {
                        return new String[]{"Cross-Cluster Replication will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] redactProcessorAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Redact ingest pipeline processors will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static boolean isBasic(License.OperationMode mode) {
        return mode == License.OperationMode.BASIC;
    }

    public XPackLicenseState(LongSupplier epochMillisProvider, XPackLicenseStatus xPackLicenseStatus) {
        this(new CopyOnWriteArrayList<LicenseStateListener>(), xPackLicenseStatus, new ConcurrentHashMap<FeatureUsage, Long>(), epochMillisProvider);
    }

    public XPackLicenseState(LongSupplier epochMillisProvider) {
        this.listeners = new CopyOnWriteArrayList<LicenseStateListener>();
        this.usage = new ConcurrentHashMap<FeatureUsage, Long>();
        this.epochMillisProvider = epochMillisProvider;
        this.xPackLicenseStatus = new XPackLicenseStatus(License.OperationMode.TRIAL, true, null);
    }

    private XPackLicenseState(List<LicenseStateListener> listeners, XPackLicenseStatus xPackLicenseStatus, Map<FeatureUsage, Long> usage, LongSupplier epochMillisProvider) {
        this.listeners = listeners;
        this.xPackLicenseStatus = xPackLicenseStatus;
        this.usage = usage;
        this.epochMillisProvider = epochMillisProvider;
    }

    private <T> T executeAgainstStatus(Function<XPackLicenseStatus, T> statusFn) {
        return statusFn.apply(this.xPackLicenseStatus);
    }

    private boolean checkAgainstStatus(Predicate<XPackLicenseStatus> statusPredicate) {
        return statusPredicate.test(this.xPackLicenseStatus);
    }

    void update(XPackLicenseStatus xPackLicenseStatus) {
        this.xPackLicenseStatus = xPackLicenseStatus;
        this.listeners.forEach(LicenseStateListener::licenseStateChanged);
    }

    public void addListener(LicenseStateListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(LicenseStateListener listener) {
        this.listeners.remove(Objects.requireNonNull(listener));
    }

    public License.OperationMode getOperationMode() {
        return this.executeAgainstStatus(statusToCheck -> statusToCheck.mode());
    }

    public boolean isActive() {
        return this.checkAgainstStatus(statusToCheck -> statusToCheck.active());
    }

    public String statusDescription() {
        return this.executeAgainstStatus(statusToCheck -> (statusToCheck.active() ? "active" : "expired") + " " + statusToCheck.mode().description() + " license");
    }

    void featureUsed(LicensedFeature feature) {
        this.checkExpiry();
        this.usage.put(new FeatureUsage(feature, null), this.epochMillisProvider.getAsLong());
    }

    void enableUsageTracking(LicensedFeature feature, String contextName) {
        this.checkExpiry();
        Objects.requireNonNull(contextName, "Context name cannot be null");
        this.usage.put(new FeatureUsage(feature, contextName), -1L);
    }

    void disableUsageTracking(LicensedFeature feature, String contextName) {
        Objects.requireNonNull(contextName, "Context name cannot be null");
        this.usage.replace(new FeatureUsage(feature, contextName), -1L, this.epochMillisProvider.getAsLong());
    }

    void cleanupUsageTracking() {
        long cutoffTime = this.epochMillisProvider.getAsLong() - TimeValue.timeValueHours(24L).getMillis();
        this.usage.entrySet().removeIf(e -> {
            long timeMillis = (Long)e.getValue();
            if (timeMillis == -1L) {
                return false;
            }
            return timeMillis < cutoffTime;
        });
    }

    boolean isAllowed(LicensedFeature feature) {
        return this.isAllowedByLicense(feature.getMinimumOperationMode(), feature.isNeedsActive());
    }

    void checkExpiry() {
        String warning = this.xPackLicenseStatus.expiryWarning();
        if (warning != null) {
            HeaderWarning.addWarning(warning, new Object[0]);
        }
    }

    public Map<FeatureUsage, Long> getLastUsed() {
        long currentTimeMillis = this.epochMillisProvider.getAsLong();
        Function<Long, Long> timeConverter = v -> v == -1L ? currentTimeMillis : v;
        return this.usage.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Long)timeConverter.apply((Long)e.getValue())));
    }

    public static boolean isFipsAllowedForOperationMode(License.OperationMode operationMode) {
        return XPackLicenseState.isAllowedByOperationMode(operationMode, License.OperationMode.PLATINUM);
    }

    static boolean isAllowedByOperationMode(License.OperationMode operationMode, License.OperationMode minimumMode) {
        if (License.OperationMode.TRIAL == operationMode) {
            return true;
        }
        return operationMode.compareTo(minimumMode) >= 0;
    }

    public XPackLicenseState copyCurrentLicenseState() {
        return this.executeAgainstStatus(statusToCheck -> new XPackLicenseState(this.listeners, (XPackLicenseStatus)statusToCheck, this.usage, this.epochMillisProvider));
    }

    @Deprecated
    public boolean isAllowedByLicense(License.OperationMode minimumMode, boolean needActive) {
        return this.checkAgainstStatus(statusToCheck -> {
            if (needActive && !statusToCheck.active()) {
                return false;
            }
            return XPackLicenseState.isAllowedByOperationMode(statusToCheck.mode(), minimumMode);
        });
    }

    public boolean isAllowedByLicense(License.OperationMode minimumMode) {
        return this.isAllowedByLicense(minimumMode, true);
    }

    static {
        LinkedHashMap<String, Object> messages = new LinkedHashMap<String, Object>();
        messages.put("security", new String[]{"Cluster health, cluster stats and indices stats operations are blocked", "All data operations (read and write) continue to work"});
        messages.put("watcher", new String[]{"PUT / GET watch APIs are disabled, DELETE watch API continues to work", "Watches execute and write to the history", "The actions of the watches don't execute"});
        messages.put("monitoring", new String[]{"The agent will stop collecting cluster and indices metrics"});
        messages.put("graph", new String[]{"Graph explore APIs are disabled"});
        messages.put("ml", new String[]{"Machine learning APIs are disabled"});
        messages.put("logstash", new String[]{"Logstash will continue to poll centrally-managed pipelines"});
        messages.put("beats", new String[]{"Beats will continue to poll centrally-managed configuration"});
        messages.put("deprecation", new String[]{"Deprecation APIs are disabled"});
        messages.put("upgrade", new String[]{"Upgrade API is disabled"});
        messages.put("sql", new String[]{"SQL support is disabled"});
        messages.put("enterprise_search", new String[]{"Search Applications, query rules and behavioral analytics will be disabled"});
        messages.put("rollup", new String[]{"Creating and Starting rollup jobs will no longer be allowed.", "Stopping/Deleting existing jobs, RollupCaps API and RollupSearch continue to function."});
        messages.put("transform", new String[]{"Creating, starting, updating transforms will no longer be allowed.", "Stopping/Deleting existing transforms continue to function."});
        messages.put("analytics", new String[]{"Aggregations provided by Analytics plugin are no longer usable."});
        messages.put("ccr", new String[]{"Creating new follower indices will be blocked", "Configuring auto-follow patterns will be blocked", "Auto-follow patterns will no longer discover new leader indices", "The CCR monitoring endpoint will be blocked", "Existing follower indices will continue to replicate data"});
        messages.put("redact_processor", new String[]{"Executing a redact processor in an ingest pipeline will fail."});
        EXPIRATION_MESSAGES = Collections.unmodifiableMap(messages);
        messages = new LinkedHashMap();
        messages.put("security", XPackLicenseState::securityAcknowledgementMessages);
        messages.put("watcher", XPackLicenseState::watcherAcknowledgementMessages);
        messages.put("monitoring", XPackLicenseState::monitoringAcknowledgementMessages);
        messages.put("graph", XPackLicenseState::graphAcknowledgementMessages);
        messages.put("ml", XPackLicenseState::machineLearningAcknowledgementMessages);
        messages.put("logstash", XPackLicenseState::logstashAcknowledgementMessages);
        messages.put("beats", XPackLicenseState::beatsAcknowledgementMessages);
        messages.put("sql", XPackLicenseState::sqlAcknowledgementMessages);
        messages.put("ccr", XPackLicenseState::ccrAcknowledgementMessages);
        messages.put("enterprise_search", XPackLicenseState::enterpriseSearchAcknowledgementMessages);
        messages.put("redact_processor", XPackLicenseState::redactProcessorAcknowledgementMessages);
        messages.put("esql", XPackLicenseState::esqlAcknowledgementMessages);
        ACKNOWLEDGMENT_MESSAGES = Collections.unmodifiableMap(messages);
    }

    public static class FeatureUsage {
        private final LicensedFeature feature;
        @Nullable
        private final String context;

        private FeatureUsage(LicensedFeature feature, String context) {
            this.feature = Objects.requireNonNull(feature, "Feature cannot be null");
            this.context = context;
        }

        public String toString() {
            return this.context == null ? this.feature.getName() : this.feature.getName() + ":" + this.context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureUsage usage = (FeatureUsage)o;
            return Objects.equals(this.feature, usage.feature) && Objects.equals(this.context, usage.context);
        }

        public int hashCode() {
            return Objects.hash(this.feature, this.context);
        }

        public LicensedFeature feature() {
            return this.feature;
        }

        public String contextName() {
            return this.context;
        }
    }
}

