/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.geoip.stats.CacheStats;

public final class GeoIpCache {
    static final Object NO_RESULT = new Object(){

        public String toString() {
            return "NO_RESULT";
        }
    };
    private final LongSupplier relativeNanoTimeProvider;
    private final Cache<CacheKey, Object> cache;
    private final AtomicLong hitsTimeInNanos = new AtomicLong(0L);
    private final AtomicLong missesTimeInNanos = new AtomicLong(0L);

    GeoIpCache(long maxSize, LongSupplier relativeNanoTimeProvider) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("geoip max cache size must be 0 or greater");
        }
        this.relativeNanoTimeProvider = relativeNanoTimeProvider;
        this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
    }

    GeoIpCache(long maxSize) {
        this(maxSize, System::nanoTime);
    }

    <RESPONSE> RESPONSE putIfAbsent(String ip, String databasePath, Function<String, RESPONSE> retrieveFunction) {
        CacheKey cacheKey = new CacheKey(ip, databasePath);
        long cacheStart = this.relativeNanoTimeProvider.getAsLong();
        Object response = this.cache.get(cacheKey);
        long cacheRequestTime = this.relativeNanoTimeProvider.getAsLong() - cacheStart;
        if (response == null) {
            long retrieveStart = this.relativeNanoTimeProvider.getAsLong();
            response = retrieveFunction.apply(ip);
            if (response == null) {
                response = NO_RESULT;
            }
            this.cache.put(cacheKey, response);
            long databaseRequestAndCachePutTime = this.relativeNanoTimeProvider.getAsLong() - retrieveStart;
            this.missesTimeInNanos.addAndGet(cacheRequestTime + databaseRequestAndCachePutTime);
        } else {
            this.hitsTimeInNanos.addAndGet(cacheRequestTime);
        }
        if (response == NO_RESULT) {
            return null;
        }
        return (RESPONSE)response;
    }

    Object get(String ip, String databasePath) {
        CacheKey cacheKey = new CacheKey(ip, databasePath);
        return this.cache.get(cacheKey);
    }

    public int purgeCacheEntriesForDatabase(Path databaseFile) {
        String databasePath = databaseFile.toString();
        int counter = 0;
        for (CacheKey key : this.cache.keys()) {
            if (!key.databasePath.equals(databasePath)) continue;
            this.cache.invalidate(key);
            ++counter;
        }
        return counter;
    }

    public int count() {
        return this.cache.count();
    }

    public CacheStats getCacheStats() {
        Cache.CacheStats stats = this.cache.stats();
        return new CacheStats(this.cache.count(), stats.getHits(), stats.getMisses(), stats.getEvictions(), TimeValue.nsecToMSec(this.hitsTimeInNanos.get()), TimeValue.nsecToMSec(this.missesTimeInNanos.get()));
    }

    private record CacheKey(String ip, String databasePath) {
    }
}

