/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.bulk.FailureStoreMetrics;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.DeletePipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.TriConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConditionalProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestInfo;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.ingest.IngestPipelineException;
import org.elasticsearch.ingest.IngestSettings;
import org.elasticsearch.ingest.IngestStats;
import org.elasticsearch.ingest.OnFailureProcessor;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.ProcessorInfo;
import org.elasticsearch.ingest.WrappingProcessor;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.internal.DocumentParsingProvider;
import org.elasticsearch.plugins.internal.XContentMeteringParserDecorator;
import org.elasticsearch.plugins.internal.XContentParserDecorator;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;

public class IngestService
implements ClusterStateApplier,
ReportingService<IngestInfo> {
    public static final String NOOP_PIPELINE_NAME = "_none";
    public static final String INGEST_ORIGIN = "ingest";
    private static final Logger logger = LogManager.getLogger(IngestService.class);
    private final MasterServiceTaskQueue<PipelineClusterStateUpdateTask> taskQueue;
    private final ClusterService clusterService;
    private final ScriptService scriptService;
    private final DocumentParsingProvider documentParsingProvider;
    private final Map<String, Processor.Factory> processorFactories;
    private volatile Map<String, PipelineHolder> pipelines = Map.of();
    private final ThreadPool threadPool;
    private final IngestMetric totalMetrics = new IngestMetric();
    private final FailureStoreMetrics failureStoreMetrics;
    private final List<Consumer<ClusterState>> ingestClusterStateListeners = new CopyOnWriteArrayList<Consumer<ClusterState>>();
    private volatile ClusterState state;
    private final FeatureService featureService;
    static final ClusterStateTaskExecutor<PipelineClusterStateUpdateTask> PIPELINE_TASK_EXECUTOR = batchExecutionContext -> {
        IngestMetadata initialIngestMetadata;
        Collection<IndexMetadata> allIndexMetadata = batchExecutionContext.initialState().metadata().indices().values();
        IngestMetadata currentIngestMetadata = initialIngestMetadata = (IngestMetadata)batchExecutionContext.initialState().metadata().custom(INGEST_ORIGIN);
        for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
            try {
                PipelineClusterStateUpdateTask task = (PipelineClusterStateUpdateTask)taskContext.getTask();
                try (Releasable ignored = taskContext.captureResponseHeaders();){
                    currentIngestMetadata = task.execute(currentIngestMetadata, allIndexMetadata);
                }
                taskContext.success(() -> task.listener.onResponse(AcknowledgedResponse.TRUE));
            }
            catch (Exception e) {
                taskContext.onFailure(e);
            }
        }
        IngestMetadata finalIngestMetadata = currentIngestMetadata;
        return finalIngestMetadata == initialIngestMetadata ? batchExecutionContext.initialState() : batchExecutionContext.initialState().copyAndUpdateMetadata(b -> b.putCustom(INGEST_ORIGIN, finalIngestMetadata));
    };

    private static BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> createScheduler(ThreadPool threadPool) {
        return (delay, command) -> threadPool.schedule((Runnable)command, TimeValue.timeValueMillis(delay), threadPool.generic());
    }

    public static MatcherWatchdog createGrokThreadWatchdog(Environment env, ThreadPool threadPool) {
        Settings settings = env.settings();
        BiFunction<Long, Runnable, Scheduler.ScheduledCancellable> scheduler = IngestService.createScheduler(threadPool);
        long intervalMillis = IngestSettings.GROK_WATCHDOG_INTERVAL.get(settings).getMillis();
        long maxExecutionTimeMillis = IngestSettings.GROK_WATCHDOG_INTERVAL.get(settings).getMillis();
        return MatcherWatchdog.newInstance(intervalMillis, maxExecutionTimeMillis, threadPool.relativeTimeInMillisSupplier(), scheduler::apply);
    }

    public IngestService(ClusterService clusterService, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, List<IngestPlugin> ingestPlugins, Client client, MatcherWatchdog matcherWatchdog, DocumentParsingProvider documentParsingProvider, FailureStoreMetrics failureStoreMetrics, FeatureService featureService) {
        this.clusterService = clusterService;
        this.scriptService = scriptService;
        this.documentParsingProvider = documentParsingProvider;
        this.processorFactories = IngestService.processorFactories(ingestPlugins, new Processor.Parameters(env, scriptService, analysisRegistry, threadPool.getThreadContext(), threadPool.relativeTimeInMillisSupplier(), IngestService.createScheduler(threadPool), this, client, threadPool.generic()::execute, matcherWatchdog));
        this.threadPool = threadPool;
        this.taskQueue = clusterService.createTaskQueue("ingest-pipelines", Priority.NORMAL, PIPELINE_TASK_EXECUTOR);
        this.failureStoreMetrics = failureStoreMetrics;
        this.featureService = featureService;
    }

    IngestService(IngestService ingestService) {
        this.clusterService = ingestService.clusterService;
        this.scriptService = ingestService.scriptService;
        this.documentParsingProvider = ingestService.documentParsingProvider;
        this.processorFactories = ingestService.processorFactories;
        this.threadPool = ingestService.threadPool;
        this.taskQueue = ingestService.taskQueue;
        this.pipelines = ingestService.pipelines;
        this.state = ingestService.state;
        this.failureStoreMetrics = ingestService.failureStoreMetrics;
        this.featureService = ingestService.featureService;
    }

    private static Map<String, Processor.Factory> processorFactories(List<IngestPlugin> ingestPlugins, Processor.Parameters parameters) {
        TreeMap<String, Processor.Factory> processorFactories = new TreeMap<String, Processor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map<String, Processor.Factory> newProcessors = ingestPlugin.getProcessors(parameters);
            for (Map.Entry<String, Processor.Factory> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Ingest processor [" + entry.getKey() + "] is already registered");
            }
        }
        logger.debug("registered ingest processor types: {}", processorFactories.keySet());
        return Map.copyOf(processorFactories);
    }

    public static void resolvePipelinesAndUpdateIndexRequest(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata) {
        IngestService.resolvePipelinesAndUpdateIndexRequest(originalRequest, indexRequest, metadata, System.currentTimeMillis());
    }

    static void resolvePipelinesAndUpdateIndexRequest(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata, long epochMillis) {
        if (!indexRequest.isPipelineResolved()) {
            Pipelines pipelines = IngestService.resolvePipelines(originalRequest, indexRequest, metadata, epochMillis);
            IngestService.setPipelineOnRequest(indexRequest, pipelines);
        }
    }

    static boolean isRolloverOnWrite(Metadata metadata, IndexRequest indexRequest) {
        DataStream dataStream = metadata.dataStreams().get(indexRequest.index());
        if (dataStream == null) {
            return false;
        }
        return dataStream.getDataComponent().isRolloverOnWrite();
    }

    public static Pipelines resolvePipelines(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata, long epochMillis) {
        if (IngestService.isRolloverOnWrite(metadata, indexRequest)) {
            return IngestService.resolvePipelinesFromIndexTemplates(indexRequest, metadata).orElse(Pipelines.NO_PIPELINES_DEFINED);
        }
        return IngestService.resolvePipelinesFromMetadata(originalRequest, indexRequest, metadata, epochMillis).or(() -> IngestService.resolvePipelinesFromIndexTemplates(indexRequest, metadata)).orElse(Pipelines.NO_PIPELINES_DEFINED);
    }

    public static void setPipelineOnRequest(IndexRequest indexRequest, Pipelines resolvedPipelines) {
        String requestPipeline = indexRequest.getPipeline();
        if (requestPipeline != null) {
            indexRequest.setPipeline(requestPipeline);
        } else {
            indexRequest.setPipeline(resolvedPipelines.defaultPipeline);
        }
        indexRequest.setFinalPipeline(resolvedPipelines.finalPipeline);
        indexRequest.isPipelineResolved(true);
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void delete(DeletePipelineRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.taskQueue.submitTask("delete-pipeline-" + request.getId(), new DeletePipelineClusterStateUpdateTask(listener, request), request.masterNodeTimeout());
    }

    static void validateNotInUse(String pipeline, Collection<IndexMetadata> allIndexMetadata) {
        ArrayList<String> defaultPipelineIndices = new ArrayList<String>();
        ArrayList<String> finalPipelineIndices = new ArrayList<String>();
        for (IndexMetadata indexMetadata : allIndexMetadata) {
            String defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(indexMetadata.getSettings());
            String finalPipeline = IndexSettings.FINAL_PIPELINE.get(indexMetadata.getSettings());
            if (pipeline.equals(defaultPipeline)) {
                defaultPipelineIndices.add(indexMetadata.getIndex().getName());
            }
            if (!pipeline.equals(finalPipeline)) continue;
            finalPipelineIndices.add(indexMetadata.getIndex().getName());
        }
        if (defaultPipelineIndices.size() > 0 || finalPipelineIndices.size() > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "pipeline [%s] cannot be deleted because it is %s%s%s", pipeline, defaultPipelineIndices.size() > 0 ? String.format(Locale.ROOT, "the default pipeline for %s index(es) including [%s]", defaultPipelineIndices.size(), defaultPipelineIndices.stream().sorted().limit(3L).collect(Collectors.joining(","))) : "", defaultPipelineIndices.size() > 0 && finalPipelineIndices.size() > 0 ? " and " : "", finalPipelineIndices.size() > 0 ? String.format(Locale.ROOT, "the final pipeline for %s index(es) including [%s]", finalPipelineIndices.size(), finalPipelineIndices.stream().sorted().limit(3L).collect(Collectors.joining(","))) : ""));
        }
    }

    public static List<PipelineConfiguration> getPipelines(ClusterState clusterState, String ... ids) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetadata().custom(INGEST_ORIGIN);
        return IngestService.innerGetPipelines(ingestMetadata, ids);
    }

    static List<PipelineConfiguration> innerGetPipelines(IngestMetadata ingestMetadata, String ... ids) {
        if (ingestMetadata == null) {
            return List.of();
        }
        if (ids.length == 0) {
            return new ArrayList<PipelineConfiguration>(ingestMetadata.getPipelines().values());
        }
        ArrayList<PipelineConfiguration> result = new ArrayList<PipelineConfiguration>(ids.length);
        for (String id : ids) {
            if (Regex.isSimpleMatchPattern(id)) {
                for (Map.Entry<String, PipelineConfiguration> entry : ingestMetadata.getPipelines().entrySet()) {
                    if (!Regex.simpleMatch(id, entry.getKey())) continue;
                    result.add(entry.getValue());
                }
                continue;
            }
            PipelineConfiguration pipeline = ingestMetadata.getPipelines().get(id);
            if (pipeline == null) continue;
            result.add(pipeline);
        }
        return result;
    }

    public void putPipeline(PutPipelineRequest request, ActionListener<AcknowledgedResponse> listener, Consumer<ActionListener<NodesInfoResponse>> nodeInfoListener) throws Exception {
        if (IngestService.isNoOpPipelineUpdate(this.state, request)) {
            listener.onResponse(AcknowledgedResponse.TRUE);
            return;
        }
        nodeInfoListener.accept(listener.delegateFailureAndWrap((l, nodeInfos) -> {
            this.validatePipelineRequest(request, (NodesInfoResponse)nodeInfos);
            this.taskQueue.submitTask("put-pipeline-" + request.getId(), new PutPipelineClusterStateUpdateTask((ActionListener<AcknowledgedResponse>)l, request), request.masterNodeTimeout());
        }));
    }

    public void validatePipelineRequest(PutPipelineRequest request, NodesInfoResponse nodeInfos) throws Exception {
        Map<String, Object> config = XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        HashMap<DiscoveryNode, IngestInfo> ingestInfos = new HashMap<DiscoveryNode, IngestInfo>();
        for (NodeInfo nodeInfo : nodeInfos.getNodes()) {
            ingestInfos.put(nodeInfo.getNode(), nodeInfo.getInfo(IngestInfo.class));
        }
        this.validatePipeline(ingestInfos, request.getId(), config);
    }

    public static boolean isNoOpPipelineUpdate(ClusterState state, PutPipelineRequest request) {
        IngestMetadata currentIngestMetadata = (IngestMetadata)state.metadata().custom(INGEST_ORIGIN);
        if (request.getVersion() == null && currentIngestMetadata != null && currentIngestMetadata.getPipelines().containsKey(request.getId())) {
            Map<String, Object> pipelineConfig = XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
            PipelineConfiguration currentPipeline = currentIngestMetadata.getPipelines().get(request.getId());
            if (currentPipeline.getConfig().equals(pipelineConfig)) {
                return true;
            }
        }
        return false;
    }

    public Pipeline getPipeline(String id) {
        if (id == null) {
            return null;
        }
        PipelineHolder holder = this.pipelines.get(id);
        if (holder != null) {
            return holder.pipeline;
        }
        return null;
    }

    public Map<String, Processor.Factory> getProcessorFactories() {
        return this.processorFactories;
    }

    @Override
    public IngestInfo info() {
        Map<String, Processor.Factory> processorFactories = this.getProcessorFactories();
        ArrayList<ProcessorInfo> processorInfoList = new ArrayList<ProcessorInfo>(processorFactories.size());
        for (Map.Entry<String, Processor.Factory> entry : processorFactories.entrySet()) {
            processorInfoList.add(new ProcessorInfo(entry.getKey()));
        }
        return new IngestInfo(processorInfoList);
    }

    Map<String, PipelineHolder> pipelines() {
        return this.pipelines;
    }

    private static void collectProcessorMetrics(CompoundProcessor compoundProcessor, List<Tuple<Processor, IngestMetric>> processorMetrics) {
        for (Tuple<Processor, IngestMetric> processorWithMetric : compoundProcessor.getProcessorsWithMetrics()) {
            boolean unwrapped;
            Processor processor = processorWithMetric.v1();
            IngestMetric metric = processorWithMetric.v2();
            do {
                unwrapped = false;
                if (processor instanceof ConditionalProcessor) {
                    ConditionalProcessor conditional = (ConditionalProcessor)processor;
                    processor = conditional.getInnerProcessor();
                    metric = conditional.getMetric();
                    unwrapped = true;
                }
                if (!(processor instanceof OnFailureProcessor)) continue;
                OnFailureProcessor onFailure = (OnFailureProcessor)processor;
                processor = onFailure.getInnerProcessor();
                metric = onFailure.getInnerMetric();
                unwrapped = true;
            } while (unwrapped);
            if (processor instanceof CompoundProcessor) {
                CompoundProcessor cp = (CompoundProcessor)processor;
                IngestService.collectProcessorMetrics(cp, processorMetrics);
                continue;
            }
            processorMetrics.add(new Tuple<Processor, IngestMetric>(processor, metric));
        }
    }

    void validatePipeline(Map<DiscoveryNode, IngestInfo> ingestInfos, String pipelineId, Map<String, Object> pipelineConfig) throws Exception {
        if (ingestInfos.isEmpty()) {
            throw new IllegalStateException("Ingest info is empty");
        }
        Pipeline pipeline = Pipeline.create(pipelineId, pipelineConfig, this.processorFactories, this.scriptService);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Processor processor : pipeline.flattenAllProcessors()) {
            try {
                processor.extraValidation();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            for (Map.Entry<DiscoveryNode, IngestInfo> entry : ingestInfos.entrySet()) {
                String type = processor.getType();
                if (entry.getValue().containsProcessor(type) || "conditional".equals(type)) continue;
                String message = "Processor type [" + processor.getType() + "] is not installed on node [" + String.valueOf(entry.getKey()) + "]";
                exceptions.add(ConfigurationUtils.newConfigurationException(processor.getType(), processor.getTag(), null, message));
            }
        }
        ExceptionsHelper.rethrowAndSuppress(exceptions);
    }

    public void executeBulkRequest(int numberOfActionRequests, final Iterable<DocWriteRequest<?>> actionRequests, final IntConsumer onDropped, Function<String, Boolean> resolveFailureStore, final TriConsumer<Integer, String, Exception> onStoreFailure, final TriConsumer<Integer, Exception, IndexDocFailureStoreStatus> onFailure, final BiConsumer<Thread, Exception> onCompletion, Executor executor) {
        assert (numberOfActionRequests > 0) : "numberOfActionRequests must be greater than 0 but was [" + numberOfActionRequests + "]";
        final Function<String, Boolean> adaptedResolveFailureStore = this.wrapResolverWithFeatureCheck(resolveFailureStore);
        executor.execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                onCompletion.accept(null, e);
            }

            @Override
            protected void doRun() {
                Thread originalThread = Thread.currentThread();
                try (RefCountingRunnable refs = new RefCountingRunnable(() -> onCompletion.accept(originalThread, null));){
                    int i = 0;
                    for (DocWriteRequest actionRequest : actionRequests) {
                        final IndexRequest indexRequest = TransportBulkAction.getIndexWriteRequest(actionRequest);
                        if (indexRequest == null) {
                            ++i;
                            continue;
                        }
                        PipelineIterator pipelines = IngestService.this.getAndResetPipelines(indexRequest);
                        final Pipeline firstPipeline = pipelines.peekFirst();
                        if (!pipelines.hasNext()) {
                            ++i;
                            continue;
                        }
                        long startTimeInNanos = System.nanoTime();
                        IngestService.this.totalMetrics.preIngest();
                        if (firstPipeline != null) {
                            firstPipeline.getMetrics().preIngestBytes(indexRequest.ramBytesUsed());
                        }
                        final int slot = i;
                        Releasable ref = refs.acquire();
                        XContentMeteringParserDecorator meteringParserDecorator = IngestService.this.documentParsingProvider.newMeteringParserDecorator(indexRequest);
                        IngestDocument ingestDocument = IngestService.newIngestDocument(indexRequest, meteringParserDecorator);
                        final org.elasticsearch.script.Metadata originalDocumentMetadata = ingestDocument.getMetadata().clone();
                        ActionListener<IngestPipelinesExecutionResult> documentListener = ActionListener.runAfter(new ActionListener<IngestPipelinesExecutionResult>(){

                            @Override
                            public void onResponse(IngestPipelinesExecutionResult result) {
                                assert (result != null);
                                if (result.success) {
                                    if (!result.shouldKeep) {
                                        onDropped.accept(slot);
                                    } else {
                                        assert (firstPipeline != null);
                                        firstPipeline.getMetrics().postIngestBytes(indexRequest.ramBytesUsed());
                                    }
                                } else {
                                    IngestService.this.totalMetrics.ingestFailed();
                                    if (IndexDocFailureStoreStatus.NOT_ENABLED.equals(result.failureStoreStatus)) {
                                        onFailure.apply(slot, result.exception, result.failureStoreStatus);
                                    } else {
                                        IngestService.updateIndexRequestMetadata(indexRequest, originalDocumentMetadata);
                                        onStoreFailure.apply(slot, result.failedIndex, result.exception);
                                    }
                                }
                            }

                            @Override
                            public void onFailure(Exception e) {
                                IngestService.this.totalMetrics.ingestFailed();
                                onFailure.apply(slot, e, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
                            }
                        }, () -> {
                            long ingestTimeInNanos = System.nanoTime() - startTimeInNanos;
                            IngestService.this.totalMetrics.postIngest(ingestTimeInNanos);
                            ref.close();
                        });
                        IngestService.this.executePipelines(pipelines, indexRequest, ingestDocument, adaptedResolveFailureStore, documentListener);
                        assert (actionRequest.index() != null);
                        ++i;
                    }
                }
            }
        });
    }

    private Function<String, Boolean> wrapResolverWithFeatureCheck(Function<String, Boolean> resolveFailureStore) {
        boolean clusterHasFailureStoreFeature = this.featureService.clusterHasFeature(this.clusterService.state(), DataStream.DATA_STREAM_FAILURE_STORE_FEATURE);
        return indexName -> {
            if (clusterHasFailureStoreFeature) {
                return (Boolean)resolveFailureStore.apply((String)indexName);
            }
            return null;
        };
    }

    private PipelineIterator getAndResetPipelines(IndexRequest indexRequest) {
        String pipelineId = indexRequest.getPipeline();
        indexRequest.setPipeline(NOOP_PIPELINE_NAME);
        String finalPipelineId = indexRequest.getFinalPipeline();
        indexRequest.setFinalPipeline(NOOP_PIPELINE_NAME);
        return new PipelineIterator(pipelineId, finalPipelineId);
    }

    private void executePipelines(PipelineIterator pipelines, IndexRequest indexRequest, IngestDocument ingestDocument, Function<String, Boolean> resolveFailureStore, ActionListener<IngestPipelinesExecutionResult> listener) {
        assert (pipelines.hasNext());
        PipelineSlot slot = pipelines.next();
        String pipelineId = slot.id();
        Pipeline pipeline = slot.pipeline();
        boolean isFinalPipeline = slot.isFinal();
        ingestDocument.resetReroute();
        String originalIndex = indexRequest.indices()[0];
        Consumer<Exception> exceptionHandler = e -> {
            String errorType = ElasticsearchException.getExceptionName(ExceptionsHelper.unwrapCause(e));
            Boolean failureStoreResolution = (Boolean)resolveFailureStore.apply(originalIndex);
            if (failureStoreResolution != null && failureStoreResolution.booleanValue()) {
                this.failureStoreMetrics.incrementFailureStore(originalIndex, errorType, FailureStoreMetrics.ErrorLocation.PIPELINE);
                listener.onResponse(IngestPipelinesExecutionResult.failAndStoreFor(originalIndex, e));
            } else if (failureStoreResolution != null) {
                this.failureStoreMetrics.incrementTotal(originalIndex);
                this.failureStoreMetrics.incrementRejected(originalIndex, errorType, FailureStoreMetrics.ErrorLocation.PIPELINE, false);
                listener.onResponse(IngestPipelinesExecutionResult.failWithoutStoringIn(originalIndex, e));
            } else {
                listener.onFailure((Exception)e);
            }
        };
        try {
            if (pipeline == null) {
                throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
            }
            indexRequest.addPipeline(pipelineId);
            IngestService.executePipeline(ingestDocument, pipeline, (keep, e) -> {
                assert (keep != null);
                if (e != null) {
                    logger.debug(() -> Strings.format("failed to execute pipeline [%s] for document [%s/%s]", pipelineId, indexRequest.index(), indexRequest.id()), (Throwable)e);
                    exceptionHandler.accept((Exception)e);
                    return;
                }
                if (!keep.booleanValue()) {
                    Boolean failureStoreResolution = (Boolean)resolveFailureStore.apply(originalIndex);
                    if (failureStoreResolution != null) {
                        IndexAbstraction indexAbstraction = (IndexAbstraction)this.state.metadata().getIndicesLookup().get(IndexNameExpressionResolver.resolveDateMathExpression(originalIndex, this.threadPool.absoluteTimeInMillis()));
                        DataStream dataStream = DataStream.resolveDataStream(indexAbstraction, this.state.metadata());
                        String dataStreamName = dataStream != null ? dataStream.getName() : originalIndex;
                        this.failureStoreMetrics.incrementTotal(dataStreamName);
                    }
                    listener.onResponse(IngestPipelinesExecutionResult.DISCARD_RESULT);
                    return;
                }
                IngestService.updateIndexRequestMetadata(indexRequest, ingestDocument.getMetadata());
                try {
                    if (ingestDocument.doNoSelfReferencesCheck()) {
                        CollectionUtils.ensureNoSelfReferences(ingestDocument.getSource(), null);
                        ingestDocument.doNoSelfReferencesCheck(false);
                    }
                }
                catch (IllegalArgumentException ex) {
                    exceptionHandler.accept(new IngestPipelineException(pipelineId, new IllegalArgumentException(Strings.format("Failed to generate the source document for ingest pipeline [%s] for document [%s/%s]", pipelineId, indexRequest.index(), indexRequest.id()), ex)));
                    return;
                }
                PipelineIterator newPipelines = pipelines;
                String newIndex = indexRequest.indices()[0];
                if (!Objects.equals(originalIndex, newIndex)) {
                    boolean cycle;
                    if (isFinalPipeline) {
                        logger.info("Service stack: [{}]", ingestDocument.getPipelineStack());
                        exceptionHandler.accept(new IngestPipelineException(pipelineId, new IllegalStateException(Strings.format("final pipeline [%s] can't change the target index (from [%s] to [%s]) for document [%s]", pipelineId, originalIndex, newIndex, indexRequest.id()))));
                        return;
                    }
                    boolean bl = cycle = !ingestDocument.updateIndexHistory(newIndex);
                    if (cycle) {
                        ArrayList<String> indexCycle = new ArrayList<String>(ingestDocument.getIndexHistory());
                        indexCycle.add(newIndex);
                        exceptionHandler.accept(new IngestPipelineException(pipelineId, new IllegalStateException(Strings.format("index cycle detected while processing pipeline [%s] for document [%s]: %s", pipelineId, indexRequest.id(), indexCycle))));
                        return;
                    }
                    indexRequest.setPipeline(null);
                    indexRequest.isPipelineResolved(false);
                    IngestService.resolvePipelinesAndUpdateIndexRequest(null, indexRequest, this.state.metadata());
                    newPipelines = this.getAndResetPipelines(indexRequest);
                    if (!ingestDocument.isReroute()) {
                        newPipelines = newPipelines.withoutDefaultPipeline();
                    }
                }
                if (newPipelines.hasNext()) {
                    this.executePipelines(newPipelines, indexRequest, ingestDocument, resolveFailureStore, listener);
                } else {
                    IngestService.updateIndexRequestSource(indexRequest, ingestDocument);
                    IngestService.cacheRawTimestamp(indexRequest, ingestDocument);
                    listener.onResponse(IngestPipelinesExecutionResult.SUCCESSFUL_RESULT);
                }
            });
        }
        catch (Exception e2) {
            logger.debug(() -> Strings.format("failed to execute pipeline [%s] for document [%s/%s]", pipelineId, indexRequest.index(), indexRequest.id()), (Throwable)e2);
            exceptionHandler.accept(e2);
        }
    }

    private static void executePipeline(IngestDocument ingestDocument, Pipeline pipeline, BiConsumer<Boolean, Exception> handler) {
        ingestDocument.executePipeline(pipeline, (result, e) -> {
            if (e != null) {
                handler.accept(true, (Exception)e);
            } else {
                handler.accept(result != null, null);
            }
        });
    }

    public IngestStats stats() {
        IngestStats.Builder statsBuilder = new IngestStats.Builder();
        statsBuilder.addTotalMetrics(this.totalMetrics);
        this.pipelines.forEach((id, holder) -> {
            Pipeline pipeline = holder.pipeline;
            CompoundProcessor rootProcessor = pipeline.getCompoundProcessor();
            statsBuilder.addPipelineMetrics((String)id, pipeline.getMetrics());
            ArrayList<Tuple<Processor, IngestMetric>> processorMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
            IngestService.collectProcessorMetrics(rootProcessor, processorMetrics);
            processorMetrics.forEach(t -> {
                Processor processor = (Processor)t.v1();
                IngestMetric processorMetric = (IngestMetric)t.v2();
                statsBuilder.addProcessorMetrics((String)id, IngestService.getProcessorName(processor), processor.getType(), processorMetric);
            });
        });
        return statsBuilder.build();
    }

    public void addIngestClusterStateListener(Consumer<ClusterState> listener) {
        this.ingestClusterStateListeners.add(listener);
    }

    static String getProcessorName(Processor processor) {
        String tag;
        if (processor instanceof ConditionalProcessor) {
            ConditionalProcessor conditionalProcessor = (ConditionalProcessor)processor;
            processor = conditionalProcessor.getInnerProcessor();
        }
        if ((tag = processor.getTag()) != null && tag.isEmpty()) {
            tag = null;
        }
        String pipelineName = null;
        if (processor instanceof PipelineProcessor) {
            PipelineProcessor pipelineProcessor = (PipelineProcessor)processor;
            pipelineName = pipelineProcessor.getPipelineTemplate().newInstance(Map.of()).execute();
        }
        if (tag == null && pipelineName == null) {
            return processor.getType();
        }
        StringBuilder sb = new StringBuilder(5);
        sb.append(processor.getType());
        if (pipelineName != null) {
            sb.append(":");
            sb.append(pipelineName);
        }
        if (tag != null) {
            sb.append(":");
            sb.append(tag);
        }
        return sb.toString();
    }

    private static IngestDocument newIngestDocument(IndexRequest request, XContentParserDecorator parserDecorator) {
        return new IngestDocument(request.index(), request.id(), request.version(), request.routing(), request.versionType(), request.sourceAsMap(parserDecorator));
    }

    private static void updateIndexRequestMetadata(IndexRequest request, org.elasticsearch.script.Metadata metadata) {
        Map<String, String> map;
        Number number;
        request.index(metadata.getIndex());
        request.id(metadata.getId());
        request.routing(metadata.getRouting());
        request.version(metadata.getVersion());
        String versionType = metadata.getVersionType();
        if (versionType != null) {
            request.versionType(VersionType.fromString(versionType));
        }
        if ((number = metadata.getIfSeqNo()) != null) {
            request.setIfSeqNo(number.longValue());
        }
        if ((number = metadata.getIfPrimaryTerm()) != null) {
            request.setIfPrimaryTerm(number.longValue());
        }
        if ((map = metadata.getDynamicTemplates()) != null) {
            HashMap<String, String> mergedDynamicTemplates = new HashMap<String, String>(request.getDynamicTemplates());
            mergedDynamicTemplates.putAll(map);
            request.setDynamicTemplates(mergedDynamicTemplates);
        }
    }

    private static void updateIndexRequestSource(IndexRequest request, IngestDocument document) {
        boolean ensureNoSelfReferences = document.doNoSelfReferencesCheck();
        assert (!ensureNoSelfReferences);
        request.source(document.getSource(), request.getContentType(), ensureNoSelfReferences);
    }

    private static void cacheRawTimestamp(IndexRequest request, IngestDocument document) {
        Object rawTimestamp;
        if (request.getRawTimestamp() == null && (rawTimestamp = document.getSource().get("@timestamp")) != null) {
            request.setRawTimestamp(rawTimestamp);
        }
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.state = event.state();
        if (this.state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.ingestClusterStateListeners.forEach(consumer -> consumer.accept(this.state));
        IngestMetadata newIngestMetadata = (IngestMetadata)this.state.getMetadata().custom(INGEST_ORIGIN);
        if (newIngestMetadata == null) {
            return;
        }
        try {
            this.innerUpdatePipelines(newIngestMetadata);
        }
        catch (ElasticsearchParseException e) {
            logger.warn("failed to update ingest pipelines", (Throwable)e);
        }
    }

    synchronized void innerUpdatePipelines(IngestMetadata newIngestMetadata) {
        Map<String, PipelineHolder> existingPipelines = this.pipelines;
        HashMap<String, PipelineHolder> newPipelines = null;
        ArrayList<ElasticsearchParseException> exceptions = null;
        for (PipelineConfiguration pipelineConfiguration : newIngestMetadata.getPipelines().values()) {
            PipelineHolder previous = existingPipelines.get(pipelineConfiguration.getId());
            if (previous != null && previous.configuration.equals(pipelineConfiguration)) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            try {
                Pipeline newPipeline = Pipeline.create(pipelineConfiguration.getId(), pipelineConfiguration.getConfig(false), this.processorFactories, this.scriptService);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, newPipeline));
                if (previous == null) continue;
                Pipeline oldPipeline = previous.pipeline;
                newPipeline.getMetrics().add(oldPipeline.getMetrics());
                ArrayList<Tuple<Processor, IngestMetric>> oldPerProcessMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
                ArrayList<Tuple<Processor, IngestMetric>> newPerProcessMetrics = new ArrayList<Tuple<Processor, IngestMetric>>();
                IngestService.collectProcessorMetrics(oldPipeline.getCompoundProcessor(), oldPerProcessMetrics);
                IngestService.collectProcessorMetrics(newPipeline.getCompoundProcessor(), newPerProcessMetrics);
                if (newPerProcessMetrics.size() != oldPerProcessMetrics.size()) continue;
                Iterator oldMetricsIterator = oldPerProcessMetrics.iterator();
                for (Tuple tuple : newPerProcessMetrics) {
                    String type = ((Processor)tuple.v1()).getType();
                    IngestMetric metric = (IngestMetric)tuple.v2();
                    if (!oldMetricsIterator.hasNext()) continue;
                    Tuple oldCompositeMetric = (Tuple)oldMetricsIterator.next();
                    String oldType = ((Processor)oldCompositeMetric.v1()).getType();
                    IngestMetric oldMetric = (IngestMetric)oldCompositeMetric.v2();
                    if (!type.equals(oldType)) continue;
                    metric.add(oldMetric);
                }
            }
            catch (ElasticsearchParseException e) {
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), e);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList<ElasticsearchParseException>();
                }
                exceptions.add(e);
            }
            catch (Exception e) {
                ElasticsearchParseException parseException = new ElasticsearchParseException("Error updating pipeline with id [" + pipelineConfiguration.getId() + "]", (Throwable)e, new Object[0]);
                Pipeline pipeline = IngestService.substitutePipeline(pipelineConfiguration.getId(), parseException);
                newPipelines.put(pipelineConfiguration.getId(), new PipelineHolder(pipelineConfiguration, pipeline));
                if (exceptions == null) {
                    exceptions = new ArrayList();
                }
                exceptions.add(parseException);
            }
        }
        for (Map.Entry entry : existingPipelines.entrySet()) {
            if (newIngestMetadata.getPipelines().get(entry.getKey()) != null) continue;
            if (newPipelines == null) {
                newPipelines = new HashMap<String, PipelineHolder>(existingPipelines);
            }
            newPipelines.remove(entry.getKey());
        }
        if (newPipelines != null) {
            this.pipelines = Map.copyOf(newPipelines);
            if (exceptions != null) {
                ExceptionsHelper.rethrowAndSuppress(exceptions);
            }
        }
    }

    public <P extends Processor> List<P> getProcessorsInPipeline(String pipelineId, Class<P> clazz) {
        Pipeline pipeline = this.getPipeline(pipelineId);
        if (pipeline == null) {
            throw new IllegalArgumentException("pipeline with id [" + pipelineId + "] does not exist");
        }
        ArrayList<Processor> processors = new ArrayList<Processor>();
        block0: for (Processor processor : pipeline.flattenAllProcessors()) {
            if (clazz.isAssignableFrom(processor.getClass())) {
                processors.add((Processor)clazz.cast(processor));
            }
            while (processor instanceof WrappingProcessor) {
                WrappingProcessor wrappingProcessor = (WrappingProcessor)processor;
                if (clazz.isAssignableFrom(wrappingProcessor.getInnerProcessor().getClass())) {
                    processors.add((Processor)clazz.cast(wrappingProcessor.getInnerProcessor()));
                }
                if (wrappingProcessor != (processor = wrappingProcessor.getInnerProcessor())) continue;
                continue block0;
            }
        }
        return processors;
    }

    public <P extends Processor> Collection<String> getPipelineWithProcessorType(Class<P> clazz, Predicate<P> predicate) {
        LinkedList<String> matchedPipelines = new LinkedList<String>();
        for (PipelineHolder holder : this.pipelines.values()) {
            String pipelineId = holder.pipeline.getId();
            List<P> processors = this.getProcessorsInPipeline(pipelineId, clazz);
            if (processors.isEmpty() || !processors.stream().anyMatch(predicate)) continue;
            matchedPipelines.add(pipelineId);
        }
        return matchedPipelines;
    }

    public synchronized void reloadPipeline(String id) throws Exception {
        PipelineHolder holder = this.pipelines.get(id);
        Pipeline updatedPipeline = Pipeline.create(id, holder.configuration.getConfig(false), this.processorFactories, this.scriptService);
        HashMap<String, PipelineHolder> updatedPipelines = new HashMap<String, PipelineHolder>(this.pipelines);
        updatedPipelines.put(id, new PipelineHolder(holder.configuration, updatedPipeline));
        this.pipelines = Map.copyOf(updatedPipelines);
    }

    private static Pipeline substitutePipeline(String id, ElasticsearchParseException e) {
        String tag = e.getHeaderKeys().contains("processor_tag") ? e.getHeader("processor_tag").get(0) : null;
        final String type = e.getHeaderKeys().contains("processor_type") ? e.getHeader("processor_type").get(0) : "unknown";
        final String errorMessage = "pipeline with id [" + id + "] could not be loaded, caused by [" + e.getDetailedMessage() + "]";
        AbstractProcessor failureProcessor = new AbstractProcessor(tag, "this is a placeholder processor"){

            @Override
            public IngestDocument execute(IngestDocument ingestDocument) {
                throw new IllegalStateException(errorMessage);
            }

            @Override
            public String getType() {
                return type;
            }
        };
        String description = "this is a place holder pipeline, because pipeline with id [" + id + "] could not be loaded";
        return new Pipeline(id, description, null, null, new CompoundProcessor(failureProcessor));
    }

    private static Optional<Pipelines> resolvePipelinesFromMetadata(DocWriteRequest<?> originalRequest, IndexRequest indexRequest, Metadata metadata, long epochMillis) {
        IndexAbstraction indexAbstraction;
        IndexMetadata indexMetadata = null;
        if (originalRequest != null) {
            indexMetadata = metadata.indices().get(IndexNameExpressionResolver.resolveDateMathExpression(originalRequest.index(), epochMillis));
        }
        if (indexMetadata == null && indexRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexRequest.index())) != null && indexAbstraction.getWriteIndex() != null) {
            indexMetadata = metadata.index(indexAbstraction.getWriteIndex());
        }
        if (indexMetadata == null && originalRequest != null && originalRequest.index() != null && (indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(originalRequest.index())) != null && indexAbstraction.getWriteIndex() != null) {
            indexMetadata = metadata.index(indexAbstraction.getWriteIndex());
        }
        if (indexMetadata == null) {
            return Optional.empty();
        }
        Settings settings = indexMetadata.getSettings();
        return Optional.of(new Pipelines(IndexSettings.DEFAULT_PIPELINE.get(settings), IndexSettings.FINAL_PIPELINE.get(settings)));
    }

    private static Optional<Pipelines> resolvePipelinesFromIndexTemplates(IndexRequest indexRequest, Metadata metadata) {
        if (indexRequest.index() == null) {
            return Optional.empty();
        }
        String v2Template = MetadataIndexTemplateService.findV2Template(metadata, indexRequest.index(), false);
        if (v2Template != null) {
            Settings settings = MetadataIndexTemplateService.resolveSettings(metadata, v2Template);
            return Optional.of(new Pipelines(IndexSettings.DEFAULT_PIPELINE.get(settings), IndexSettings.FINAL_PIPELINE.get(settings)));
        }
        String defaultPipeline = null;
        String finalPipeline = null;
        List<IndexTemplateMetadata> templates = MetadataIndexTemplateService.findV1Templates(metadata, indexRequest.index(), null);
        for (IndexTemplateMetadata template : templates) {
            Settings settings = template.settings();
            if (defaultPipeline == null && IndexSettings.DEFAULT_PIPELINE.exists(settings)) {
                defaultPipeline = IndexSettings.DEFAULT_PIPELINE.get(settings);
            }
            if (finalPipeline == null && IndexSettings.FINAL_PIPELINE.exists(settings)) {
                finalPipeline = IndexSettings.FINAL_PIPELINE.get(settings);
            }
            if (defaultPipeline == null || finalPipeline == null) continue;
            break;
        }
        defaultPipeline = Objects.requireNonNullElse(defaultPipeline, NOOP_PIPELINE_NAME);
        finalPipeline = Objects.requireNonNullElse(finalPipeline, NOOP_PIPELINE_NAME);
        return Optional.of(new Pipelines(defaultPipeline, finalPipeline));
    }

    public static boolean hasPipeline(IndexRequest indexRequest) {
        assert (indexRequest.isPipelineResolved());
        assert (indexRequest.getPipeline() != null);
        assert (indexRequest.getFinalPipeline() != null);
        return !NOOP_PIPELINE_NAME.equals(indexRequest.getPipeline()) || !NOOP_PIPELINE_NAME.equals(indexRequest.getFinalPipeline());
    }

    public record Pipelines(String defaultPipeline, String finalPipeline) {
        private static final Pipelines NO_PIPELINES_DEFINED = new Pipelines("_none", "_none");

        public Pipelines {
            Objects.requireNonNull(defaultPipeline);
            Objects.requireNonNull(finalPipeline);
        }
    }

    public static class DeletePipelineClusterStateUpdateTask
    extends PipelineClusterStateUpdateTask {
        private final DeletePipelineRequest request;

        DeletePipelineClusterStateUpdateTask(ActionListener<AcknowledgedResponse> listener, DeletePipelineRequest request) {
            super(listener);
            this.request = request;
        }

        public DeletePipelineClusterStateUpdateTask(String id) {
            this(null, new DeletePipelineRequest(id));
        }

        @Override
        public IngestMetadata execute(IngestMetadata currentIngestMetadata, Collection<IndexMetadata> allIndexMetadata) {
            if (currentIngestMetadata == null) {
                return null;
            }
            Map<String, PipelineConfiguration> pipelines = currentIngestMetadata.getPipelines();
            HashSet<String> toRemove = new HashSet<String>();
            for (String pipelineKey : pipelines.keySet()) {
                if (!Regex.simpleMatch(this.request.getId(), pipelineKey)) continue;
                toRemove.add(pipelineKey);
            }
            if (toRemove.isEmpty() && !Regex.isMatchAllPattern(this.request.getId())) {
                throw new ResourceNotFoundException("pipeline [{}] is missing", this.request.getId());
            }
            if (toRemove.isEmpty()) {
                return currentIngestMetadata;
            }
            HashMap<String, PipelineConfiguration> pipelinesCopy = new HashMap<String, PipelineConfiguration>(pipelines);
            for (String key : toRemove) {
                IngestService.validateNotInUse(key, allIndexMetadata);
                pipelinesCopy.remove(key);
            }
            return new IngestMetadata(pipelinesCopy);
        }
    }

    record PipelineHolder(PipelineConfiguration configuration, Pipeline pipeline) {
        public PipelineHolder {
            Objects.requireNonNull(configuration);
            Objects.requireNonNull(pipeline);
        }
    }

    private class PipelineIterator
    implements Iterator<PipelineSlot> {
        private final String defaultPipeline;
        private final String finalPipeline;
        private final Iterator<PipelineSlot> pipelineSlotIterator;

        private PipelineIterator(String defaultPipeline, String finalPipeline) {
            this.defaultPipeline = IngestService.NOOP_PIPELINE_NAME.equals(defaultPipeline) ? null : defaultPipeline;
            this.finalPipeline = IngestService.NOOP_PIPELINE_NAME.equals(finalPipeline) ? null : finalPipeline;
            this.pipelineSlotIterator = this.iterator();
        }

        public PipelineIterator withoutDefaultPipeline() {
            return new PipelineIterator(null, this.finalPipeline);
        }

        private Iterator<PipelineSlot> iterator() {
            PipelineSlot defaultPipelineSlot = null;
            PipelineSlot finalPipelineSlot = null;
            if (this.defaultPipeline != null) {
                defaultPipelineSlot = new PipelineSlot(this.defaultPipeline, IngestService.this.getPipeline(this.defaultPipeline), false);
            }
            if (this.finalPipeline != null) {
                finalPipelineSlot = new PipelineSlot(this.finalPipeline, IngestService.this.getPipeline(this.finalPipeline), true);
            }
            if (this.defaultPipeline != null && this.finalPipeline != null) {
                return List.of(defaultPipelineSlot, finalPipelineSlot).iterator();
            }
            if (this.finalPipeline != null) {
                return List.of(finalPipelineSlot).iterator();
            }
            if (this.defaultPipeline != null) {
                return List.of(defaultPipelineSlot).iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            return this.pipelineSlotIterator.hasNext();
        }

        @Override
        public PipelineSlot next() {
            return this.pipelineSlotIterator.next();
        }

        public Pipeline peekFirst() {
            return IngestService.this.getPipeline(this.defaultPipeline != null ? this.defaultPipeline : this.finalPipeline);
        }
    }

    private record PipelineSlot(String id, @Nullable Pipeline pipeline, boolean isFinal) {
        public PipelineSlot {
            Objects.requireNonNull(id);
        }
    }

    private record IngestPipelinesExecutionResult(boolean success, boolean shouldKeep, Exception exception, String failedIndex, IndexDocFailureStoreStatus failureStoreStatus) {
        private static final IngestPipelinesExecutionResult SUCCESSFUL_RESULT = new IngestPipelinesExecutionResult(true, true, null, null, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
        private static final IngestPipelinesExecutionResult DISCARD_RESULT = new IngestPipelinesExecutionResult(true, false, null, null, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);

        private static IngestPipelinesExecutionResult failAndStoreFor(String index, Exception e) {
            return new IngestPipelinesExecutionResult(false, true, e, index, IndexDocFailureStoreStatus.USED);
        }

        private static IngestPipelinesExecutionResult failWithoutStoringIn(String index, Exception e) {
            return new IngestPipelinesExecutionResult(false, true, e, index, IndexDocFailureStoreStatus.NOT_ENABLED);
        }
    }

    public static class PutPipelineClusterStateUpdateTask
    extends PipelineClusterStateUpdateTask {
        private final PutPipelineRequest request;

        PutPipelineClusterStateUpdateTask(ActionListener<AcknowledgedResponse> listener, PutPipelineRequest request) {
            super(listener);
            this.request = request;
        }

        public PutPipelineClusterStateUpdateTask(PutPipelineRequest request) {
            this(null, request);
        }

        @Override
        public IngestMetadata execute(IngestMetadata currentIngestMetadata, Collection<IndexMetadata> allIndexMetadata) {
            BytesReference pipelineSource = this.request.getSource();
            if (this.request.getVersion() != null) {
                PipelineConfiguration currentPipeline;
                PipelineConfiguration pipelineConfiguration = currentPipeline = currentIngestMetadata != null ? currentIngestMetadata.getPipelines().get(this.request.getId()) : null;
                if (currentPipeline == null) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "version conflict, required version [%s] for pipeline [%s] but no pipeline was found", this.request.getVersion(), this.request.getId()));
                }
                Integer currentVersion = currentPipeline.getVersion();
                if (!Objects.equals(this.request.getVersion(), currentVersion)) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "version conflict, required version [%s] for pipeline [%s] but current version is [%s]", this.request.getVersion(), this.request.getId(), currentVersion));
                }
                Map<String, Object> pipelineConfig = XContentHelper.convertToMap(this.request.getSource(), false, this.request.getXContentType()).v2();
                Integer specifiedVersion = (Integer)pipelineConfig.get("version");
                if (pipelineConfig.containsKey("version") && Objects.equals(specifiedVersion, currentVersion)) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot update pipeline [%s] with the same version [%s]", this.request.getId(), this.request.getVersion()));
                }
                if (specifiedVersion == null) {
                    pipelineConfig.put("version", this.request.getVersion() == null ? 1 : this.request.getVersion() + 1);
                    try {
                        XContentBuilder builder = XContentBuilder.builder(this.request.getXContentType().xContent()).map(pipelineConfig);
                        pipelineSource = BytesReference.bytes(builder);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            HashMap<String, PipelineConfiguration> pipelines = currentIngestMetadata != null ? new HashMap<String, PipelineConfiguration>(currentIngestMetadata.getPipelines()) : new HashMap<String, PipelineConfiguration>();
            pipelines.put(this.request.getId(), new PipelineConfiguration(this.request.getId(), pipelineSource, this.request.getXContentType()));
            return new IngestMetadata(pipelines);
        }
    }

    public static abstract class PipelineClusterStateUpdateTask
    implements ClusterStateTaskListener {
        final ActionListener<AcknowledgedResponse> listener;

        PipelineClusterStateUpdateTask(ActionListener<AcknowledgedResponse> listener) {
            this.listener = listener;
        }

        public abstract IngestMetadata execute(IngestMetadata var1, Collection<IndexMetadata> var2);

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

