/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.grok;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.elasticsearch.grok.GrokCaptureExtracter;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.grok.PatternBank;
import org.elasticsearch.grok.shaded.org.jcodings.Encoding;
import org.elasticsearch.grok.shaded.org.jcodings.specific.UTF8Encoding;
import org.elasticsearch.grok.shaded.org.joni.Matcher;
import org.elasticsearch.grok.shaded.org.joni.NameEntry;
import org.elasticsearch.grok.shaded.org.joni.Regex;
import org.elasticsearch.grok.shaded.org.joni.Region;
import org.elasticsearch.grok.shaded.org.joni.Syntax;

public final class Grok {
    private static final String NAME_GROUP = "name";
    private static final String SUBNAME_GROUP = "subname";
    private static final String PATTERN_GROUP = "pattern";
    private static final String DEFINITION_GROUP = "definition";
    private static final String GROK_PATTERN = "%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:[^{}]+|\\.+)+))?\\}";
    private static final Regex GROK_PATTERN_REGEX = new Regex("%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:[^{}]+|\\.+)+))?\\}".getBytes(StandardCharsets.UTF_8), 0, "%\\{(?<name>(?<pattern>[A-z0-9]+)(?::(?<subname>[[:alnum:]@\\[\\]_:.-]+))?)(?:=(?<definition>(?:[^{}]+|\\.+)+))?\\}".getBytes(StandardCharsets.UTF_8).length, 0, (Encoding)UTF8Encoding.INSTANCE, Syntax.DEFAULT);
    private static final int MAX_TO_REGEX_ITERATIONS = 100000;
    private final boolean namedCaptures;
    private final Regex compiledExpression;
    private final MatcherWatchdog matcherWatchdog;
    private final List<GrokCaptureConfig> captureConfig;

    public Grok(PatternBank patternBank, String grokPattern, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, true, MatcherWatchdog.noop(), logCallBack);
    }

    public Grok(PatternBank patternBank, String grokPattern, MatcherWatchdog matcherWatchdog, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, true, matcherWatchdog, logCallBack);
    }

    Grok(PatternBank patternBank, String grokPattern, boolean namedCaptures, Consumer<String> logCallBack) {
        this(patternBank, grokPattern, namedCaptures, MatcherWatchdog.noop(), logCallBack);
    }

    private Grok(PatternBank patternBank, String grokPattern, boolean namedCaptures, MatcherWatchdog matcherWatchdog, Consumer<String> logCallBack) {
        this.namedCaptures = namedCaptures;
        this.matcherWatchdog = matcherWatchdog;
        String expression = this.toRegex(patternBank, grokPattern);
        byte[] expressionBytes = expression.getBytes(StandardCharsets.UTF_8);
        this.compiledExpression = new Regex(expressionBytes, 0, expressionBytes.length, 0, (Encoding)UTF8Encoding.INSTANCE, logCallBack::accept);
        ArrayList<GrokCaptureConfig> grokCaptureConfigs = new ArrayList<GrokCaptureConfig>();
        Iterator<NameEntry> entry = this.compiledExpression.namedBackrefIterator();
        while (entry.hasNext()) {
            grokCaptureConfigs.add(new GrokCaptureConfig(entry.next()));
        }
        this.captureConfig = List.copyOf(grokCaptureConfigs);
    }

    private static String groupMatch(String name, Region region, String pattern) {
        int number = GROK_PATTERN_REGEX.nameToBackrefNumber(name.getBytes(StandardCharsets.UTF_8), 0, name.getBytes(StandardCharsets.UTF_8).length, region);
        int begin = region.beg[number];
        int end = region.end[number];
        if (begin < 0) {
            return null;
        }
        return new String(pattern.getBytes(StandardCharsets.UTF_8), begin, end - begin, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toRegex(PatternBank patternBank, String grokPattern) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 100000; ++i) {
            int result;
            byte[] grokPatternBytes = ((String)grokPattern).getBytes(StandardCharsets.UTF_8);
            Matcher matcher = GROK_PATTERN_REGEX.matcher(grokPatternBytes);
            try {
                this.matcherWatchdog.register(matcher);
                result = matcher.search(0, grokPatternBytes.length, 0);
            }
            finally {
                this.matcherWatchdog.unregister(matcher);
            }
            if (result < 0) {
                return res.append((String)grokPattern).toString();
            }
            Region region = matcher.getEagerRegion();
            String namedPatternRef = Grok.groupMatch(NAME_GROUP, region, (String)grokPattern);
            String subName = Grok.groupMatch(SUBNAME_GROUP, region, (String)grokPattern);
            String definition = Grok.groupMatch(DEFINITION_GROUP, region, (String)grokPattern);
            String patternName = Grok.groupMatch(PATTERN_GROUP, region, (String)grokPattern);
            String pattern = patternBank.get(patternName);
            if (pattern == null) {
                throw new IllegalArgumentException("Unable to find pattern [" + patternName + "] in Grok's pattern dictionary");
            }
            if (pattern.contains("%{" + patternName + "}") || pattern.contains("%{" + patternName + ":")) {
                throw new IllegalArgumentException("circular reference in pattern back [" + patternName + "]");
            }
            String grokPart = this.namedCaptures && subName != null ? String.format(Locale.US, "(?<%s>%s)", namedPatternRef, pattern) : (this.namedCaptures ? String.format(Locale.US, "(?:%s)", pattern) : String.format(Locale.US, "(?<%s>%s)", patternName + "_" + result, pattern));
            String start = new String(grokPatternBytes, 0, result, StandardCharsets.UTF_8);
            String rest = new String(grokPatternBytes, region.end[0], grokPatternBytes.length - region.end[0], StandardCharsets.UTF_8);
            grokPattern = grokPart + rest;
            res.append(start);
        }
        throw new IllegalArgumentException("Can not convert grok patterns to regular expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(String text) {
        int result;
        Matcher matcher = this.compiledExpression.matcher(text.getBytes(StandardCharsets.UTF_8));
        try {
            this.matcherWatchdog.register(matcher);
            result = matcher.search(0, text.length(), 0);
        }
        finally {
            this.matcherWatchdog.unregister(matcher);
        }
        return result != -1;
    }

    public Map<String, Object> captures(String text) {
        return this.innerCaptures(text, cfg -> cfg::objectExtracter);
    }

    public Map<String, Object> captureRanges(String text) {
        return this.innerCaptures(text, cfg -> cfg::rangeExtracter);
    }

    private Map<String, Object> innerCaptures(String text, Function<GrokCaptureConfig, Function<Consumer<Object>, GrokCaptureExtracter>> getExtracter) {
        GrokCaptureExtracter.MapExtracter extracter;
        byte[] utf8Bytes = text.getBytes(StandardCharsets.UTF_8);
        if (this.match(utf8Bytes, 0, utf8Bytes.length, extracter = new GrokCaptureExtracter.MapExtracter(this.captureConfig, getExtracter))) {
            return extracter.result();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(byte[] utf8Bytes, int offset, int length, GrokCaptureExtracter extracter) {
        int result;
        Matcher matcher = this.compiledExpression.matcher(utf8Bytes, offset, offset + length);
        try {
            this.matcherWatchdog.register(matcher);
            result = matcher.search(offset, offset + length, 0);
        }
        finally {
            this.matcherWatchdog.unregister(matcher);
        }
        if (result == -2) {
            throw new RuntimeException("grok pattern matching was interrupted after [" + this.matcherWatchdog.maxExecutionTimeInMillis() + "] ms");
        }
        if (result == -1) {
            return false;
        }
        extracter.extract(utf8Bytes, offset, matcher.getEagerRegion());
        return true;
    }

    public List<GrokCaptureConfig> captureConfig() {
        return this.captureConfig;
    }

    public Regex getCompiledExpression() {
        return this.compiledExpression;
    }
}

