/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.geo.GeometryFormatterFactory;
import org.elasticsearch.geometry.Geometry;

public class GeoFormatterFactory<T> {
    private final Map<String, Function<String, Function<List<T>, List<Object>>>> factories;

    public GeoFormatterFactory(List<FormatterFactory<T>> factories) {
        HashMap<String, Function<String, Function<List<T>, List<Object>>>> factoriesBuilder = new HashMap<String, Function<String, Function<List<T>, List<Object>>>>();
        for (FormatterFactory<T> factory : factories) {
            if (factoriesBuilder.put(factory.getName(), factory.getFormatterBuilder()) == null) continue;
            throw new IllegalArgumentException("More then one formatter factory with the name [" + factory.getName() + "] was configured");
        }
        this.factories = Collections.unmodifiableMap(factoriesBuilder);
    }

    public Function<List<T>, List<Object>> getFormatter(String format, Function<T, Geometry> toGeometry) {
        int start = format.indexOf(40);
        if (start == -1) {
            return GeometryFormatterFactory.getFormatter(format, toGeometry);
        }
        String formatName = format.substring(0, start);
        Function<String, Function<List<String>, List<Object>>> factory = this.factories.get(formatName);
        if (factory == null) {
            throw new IllegalArgumentException("Invalid format: " + formatName);
        }
        String param = format.substring(start + 1, format.length() - 1);
        return factory.apply(param);
    }

    public static interface FormatterFactory<T> {
        public String getName();

        public Function<String, Function<List<T>, List<Object>>> getFormatterBuilder();
    }
}

