/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.LDAPConnectionDetailsJSONSpecification;
import com.unboundid.util.json.SecurityOptions;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class ConnectionOptions
implements Serializable {
    @NotNull
    private static final String FIELD_CONNECT_TIMEOUT_MILLIS = "connect-timeout-millis";
    @NotNull
    private static final String FIELD_DEFAULT_RESPONSE_TIMEOUT_MILLIS = "default-response-timeout-millis";
    @NotNull
    private static final String FIELD_FOLLOW_REFERRALS = "follow-referrals";
    @NotNull
    private static final String FIELD_USE_SCHEMA = "use-schema";
    @NotNull
    private static final String FIELD_USE_SYNCHRONOUS_MODE = "use-synchronous-mode";
    private static final long serialVersionUID = 4615610794723107852L;
    private final boolean followReferrals;
    private final boolean useSchema;
    private final boolean useSynchronousMode;
    private final int connectTimeoutMillis;
    private final long defaultResponseTimeoutMillis;

    ConnectionOptions(@NotNull JSONObject connectionDetailsObject) throws LDAPException {
        boolean referrals = false;
        boolean schema = false;
        boolean synchronous = false;
        int connect = 60000;
        long response = 300000L;
        JSONObject o = LDAPConnectionDetailsJSONSpecification.getObject(connectionDetailsObject, "connection-options");
        if (o != null) {
            LDAPConnectionDetailsJSONSpecification.validateAllowedFields(o, "connection-options", FIELD_CONNECT_TIMEOUT_MILLIS, FIELD_DEFAULT_RESPONSE_TIMEOUT_MILLIS, FIELD_FOLLOW_REFERRALS, FIELD_USE_SCHEMA, FIELD_USE_SYNCHRONOUS_MODE);
            referrals = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_FOLLOW_REFERRALS, referrals);
            schema = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_USE_SCHEMA, schema);
            synchronous = LDAPConnectionDetailsJSONSpecification.getBoolean(o, FIELD_USE_SYNCHRONOUS_MODE, synchronous);
            connect = LDAPConnectionDetailsJSONSpecification.getInt(o, FIELD_CONNECT_TIMEOUT_MILLIS, connect, 0, null);
            response = LDAPConnectionDetailsJSONSpecification.getLong(o, FIELD_DEFAULT_RESPONSE_TIMEOUT_MILLIS, response, 0L, null);
        }
        this.followReferrals = referrals;
        this.useSchema = schema;
        this.useSynchronousMode = synchronous;
        this.connectTimeoutMillis = connect;
        this.defaultResponseTimeoutMillis = response;
    }

    @NotNull
    LDAPConnectionOptions createConnectionOptions(@NotNull SecurityOptions securityOptions) {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setFollowReferrals(this.followReferrals);
        options.setUseSchema(this.useSchema);
        options.setUseSynchronousMode(this.useSynchronousMode);
        options.setConnectTimeoutMillis(this.connectTimeoutMillis);
        options.setResponseTimeoutMillis(this.defaultResponseTimeoutMillis);
        if (securityOptions.verifyAddressInCertificate()) {
            options.setSSLSocketVerifier(new HostNameSSLSocketVerifier(true));
        }
        return options;
    }
}

