/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.resolver;

import co.elastic.logstash.filters.elasticintegration.resolver.CacheReloader;
import co.elastic.logstash.filters.elasticintegration.resolver.CacheableResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.CachingResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.ResolverCache;
import java.util.Optional;
import java.util.function.Consumer;

public class SimpleCachingResolver<K, V>
implements CachingResolver<K, V> {
    private final ResolverCache<K, V> cache;
    private final CacheableResolver.Ephemeral<K, V> cacheMissResolver;

    public SimpleCachingResolver(ResolverCache<K, V> cache, CacheableResolver<K, V> cacheMissResolver) {
        this(cache, Bindable.constant(cacheMissResolver::resolve));
    }

    public SimpleCachingResolver(ResolverCache<K, V> cache, Bindable<K, V> bindable) {
        this.cache = cache;
        this.cacheMissResolver = bindable.withCachingResolverBinding(this);
    }

    @Override
    public Optional<V> resolve(K resolveKey, Consumer<Exception> exceptionHandler) {
        return this.cache.resolve(resolveKey, this.cacheMissResolver, exceptionHandler);
    }

    @Override
    public CacheReloader getReloader() {
        return this.cache.getReloader(this.cacheMissResolver);
    }

    @FunctionalInterface
    public static interface Bindable<K, V> {
        public CacheableResolver.Ephemeral<K, V> withCachingResolverBinding(SimpleCachingResolver<K, V> var1);

        public static <KK, VV> Bindable<KK, VV> constant(CacheableResolver.Ephemeral<KK, VV> unboundEphemeral) {
            return ignoredBinding -> unboundEphemeral;
        }
    }
}

