/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.filters.elasticintegration.IngestPipeline;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineFactory;
import co.elastic.logstash.filters.elasticintegration.IngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.PipelineConfigurationResolver;
import co.elastic.logstash.filters.elasticintegration.SimpleCachingIngestPipelineResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.CacheableResolver;
import co.elastic.logstash.filters.elasticintegration.resolver.ResolverCache;
import co.elastic.logstash.filters.elasticintegration.resolver.SimpleCachingResolver;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.elasticsearch.ingest.PipelineConfiguration;

final class SimpleIngestPipelineResolver
implements IngestPipelineResolver,
CacheableResolver<String, IngestPipeline>,
SimpleCachingResolver.Bindable<String, IngestPipeline> {
    private final PipelineConfigurationResolver pipelineConfigurationResolver;
    private final IngestPipelineFactory ingestPipelineFactory;

    public SimpleIngestPipelineResolver(PipelineConfigurationResolver pipelineConfigurationResolver, IngestPipelineFactory ingestPipelineFactory) {
        this(pipelineConfigurationResolver, ingestPipelineFactory, null);
    }

    private SimpleIngestPipelineResolver(PipelineConfigurationResolver pipelineConfigurationResolver, IngestPipelineFactory ingestPipelineFactory, IngestPipelineResolver binding) {
        this.pipelineConfigurationResolver = pipelineConfigurationResolver;
        this.ingestPipelineFactory = ingestPipelineFactory.withIngestPipelineResolver(Objects.requireNonNullElse(binding, this));
    }

    @Override
    public CacheableResolver.Ephemeral<String, IngestPipeline> withCachingResolverBinding(SimpleCachingResolver<String, IngestPipeline> cachingResolver) {
        SimpleIngestPipelineResolver boundCacheableResolver = new SimpleIngestPipelineResolver(this.pipelineConfigurationResolver, this.ingestPipelineFactory, cachingResolver::resolve);
        return boundCacheableResolver::resolve;
    }

    @Override
    public Optional<IngestPipeline> resolve(String resolveKey, Consumer<Exception> exceptionHandler) {
        return this.pipelineConfigurationResolver.resolve(resolveKey, exceptionHandler).flatMap(pc -> {
            try {
                return this.ingestPipelineFactory.create((PipelineConfiguration)pc);
            }
            catch (Exception e) {
                exceptionHandler.accept(e);
                return Optional.empty();
            }
        });
    }

    public SimpleCachingIngestPipelineResolver withCache(ResolverCache<String, IngestPipeline> cache) {
        return new SimpleCachingIngestPipelineResolver(cache, this);
    }
}

