/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.JobStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetJobStatsResponse
implements JsonpSerializable {
    private final long count;
    private final List<JobStats> jobs;
    public static final JsonpDeserializer<GetJobStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetJobStatsResponse::setupGetJobStatsResponseDeserializer);

    private GetJobStatsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.jobs = ApiTypeHelper.unmodifiableRequired(builder.jobs, (Object)this, "jobs");
    }

    public static GetJobStatsResponse of(Function<Builder, ObjectBuilder<GetJobStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<JobStats> jobs() {
        return this.jobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.jobs)) {
            generator.writeKey("jobs");
            generator.writeStartArray();
            for (JobStats item0 : this.jobs) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetJobStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::jobs, JsonpDeserializer.arrayDeserializer(JobStats._DESERIALIZER), "jobs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetJobStatsResponse> {
        private Long count;
        private List<JobStats> jobs;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder jobs(List<JobStats> list) {
            this.jobs = Builder._listAddAll(this.jobs, list);
            return this;
        }

        public final Builder jobs(JobStats value, JobStats ... values) {
            this.jobs = Builder._listAdd(this.jobs, value, values);
            return this;
        }

        public final Builder jobs(Function<JobStats.Builder, ObjectBuilder<JobStats>> fn) {
            return this.jobs(fn.apply(new JobStats.Builder()).build(), new JobStats[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetJobStatsResponse build() {
            this._checkSingleUse();
            return new GetJobStatsResponse(this);
        }
    }
}

