/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions.throttler;

import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;

public interface Throttler {
    public Result throttle(String var1, WatchExecutionContext var2);

    public static class Result {
        public static final Result NO = new Result(Type.NONE, false, null);
        private Type type;
        private final boolean throttle;
        private final String reason;

        private Result(Type type, boolean throttle, String reason) {
            this.type = type;
            this.throttle = throttle;
            this.reason = reason;
        }

        public static Result throttle(Type type, String reason, Object ... args) {
            return new Result(type, true, LoggerMessageFormat.format(reason, args));
        }

        public boolean throttle() {
            return this.throttle;
        }

        public String reason() {
            return this.reason;
        }

        public Type type() {
            return this.type;
        }
    }

    public static enum Type {
        ACK,
        LICENSE,
        PERIOD,
        NONE;

    }
}

