/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.support.CacheKey;

public final class FieldPermissionsDefinition
implements CacheKey {
    private final SortedSet<FieldGrantExcludeGroup> fieldGrantExcludeGroups;

    public FieldPermissionsDefinition(String[] grant, String[] exclude) {
        this(Collections.singleton(new FieldGrantExcludeGroup(grant, exclude)));
    }

    public FieldPermissionsDefinition(Set<FieldGrantExcludeGroup> fieldGrantExcludeGroups) {
        this.fieldGrantExcludeGroups = new TreeSet<FieldGrantExcludeGroup>(fieldGrantExcludeGroups);
    }

    public Set<FieldGrantExcludeGroup> getFieldGrantExcludeGroups() {
        return Set.copyOf(this.fieldGrantExcludeGroups);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPermissionsDefinition that = (FieldPermissionsDefinition)o;
        return Objects.equals(this.fieldGrantExcludeGroups, that.fieldGrantExcludeGroups);
    }

    public int hashCode() {
        return this.fieldGrantExcludeGroups.hashCode();
    }

    public String toString() {
        return "FieldPermissionsDefinition{fieldGrantExcludeGroups=" + String.valueOf(this.fieldGrantExcludeGroups) + "}";
    }

    @Override
    public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
        out.writeCollection(this.fieldGrantExcludeGroups, (o, g) -> g.buildCacheKey(o, context));
    }

    public static final class FieldGrantExcludeGroup
    implements CacheKey,
    Comparable<FieldGrantExcludeGroup> {
        private final String[] grantedFields;
        private final String[] excludedFields;

        public FieldGrantExcludeGroup(String[] grantedFields, String[] excludedFields) {
            this.grantedFields = grantedFields;
            this.excludedFields = excludedFields;
        }

        public String[] getGrantedFields() {
            return this.grantedFields;
        }

        public String[] getExcludedFields() {
            return this.excludedFields;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldGrantExcludeGroup that = (FieldGrantExcludeGroup)o;
            if (!Arrays.equals(this.grantedFields, that.grantedFields)) {
                return false;
            }
            return Arrays.equals(this.excludedFields, that.excludedFields);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.grantedFields);
            result = 31 * result + Arrays.hashCode(this.excludedFields);
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[grant=" + Strings.arrayToCommaDelimitedString(this.grantedFields) + "; exclude=" + Strings.arrayToCommaDelimitedString(this.excludedFields) + "]";
        }

        @Override
        public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
            out.writeOptionalStringArray(this.grantedFields);
            out.writeOptionalStringArray(this.excludedFields);
        }

        @Override
        public int compareTo(FieldGrantExcludeGroup o) {
            int compare = Arrays.compare((Comparable[])this.grantedFields, (Comparable[])o.grantedFields);
            return compare == 0 ? Arrays.compare((Comparable[])this.excludedFields, (Comparable[])o.excludedFields) : compare;
        }
    }
}

