/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.Authentication;

public class OpenIdConnectAuthenticateResponse
extends ActionResponse {
    private final String principal;
    private final String accessTokenString;
    private final String refreshTokenString;
    private final TimeValue expiresIn;
    private final Authentication authentication;

    public OpenIdConnectAuthenticateResponse(Authentication authentication, String accessTokenString, String refreshTokenString, TimeValue expiresIn) {
        this.principal = authentication.getEffectiveSubject().getUser().principal();
        this.accessTokenString = accessTokenString;
        this.refreshTokenString = refreshTokenString;
        this.expiresIn = expiresIn;
        this.authentication = authentication;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getAccessTokenString() {
        return this.accessTokenString;
    }

    public String getRefreshTokenString() {
        return this.refreshTokenString;
    }

    public TimeValue getExpiresIn() {
        return this.expiresIn;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        out.writeString(this.accessTokenString);
        out.writeString(this.refreshTokenString);
        out.writeTimeValue(this.expiresIn);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_11_0)) {
            this.authentication.writeTo(out);
        }
    }
}

