/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetInferenceServicesAction
extends ActionType<Response> {
    public static final GetInferenceServicesAction INSTANCE = new GetInferenceServicesAction();
    public static final String NAME = "cluster:monitor/xpack/inference/services/get";

    public GetInferenceServicesAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final List<InferenceServiceConfiguration> configurations;

        public Response(List<InferenceServiceConfiguration> configurations) {
            this.configurations = configurations;
        }

        public List<InferenceServiceConfiguration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.configurations);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (InferenceServiceConfiguration configuration : this.configurations) {
                if (configuration == null) continue;
                configuration.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.configurations, response.configurations);
        }

        public int hashCode() {
            return Objects.hash(this.configurations);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final TaskType taskType;

        public Request(TaskType taskType) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.taskType = Objects.requireNonNull(taskType);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskType = TaskType.fromStream(in);
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.taskType.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.taskType == request.taskType;
        }

        public int hashCode() {
            return Objects.hash(this.taskType);
        }
    }
}

