/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.DownsampleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.MigrateAction;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.UnfollowAction;

public class TimeseriesLifecycleType
implements LifecycleType {
    public static final TimeseriesLifecycleType INSTANCE = new TimeseriesLifecycleType();
    public static final String TYPE = "timeseries";
    static final String HOT_PHASE = "hot";
    static final String WARM_PHASE = "warm";
    static final String COLD_PHASE = "cold";
    static final String FROZEN_PHASE = "frozen";
    static final String DELETE_PHASE = "delete";
    public static final List<String> ORDERED_VALID_PHASES = List.of("hot", "warm", "cold", "frozen", "delete");
    public static final List<String> ORDERED_VALID_HOT_ACTIONS = List.of("set_priority", "unfollow", "rollover", "readonly", "downsample", "shrink", "forcemerge", "searchable_snapshot");
    public static final List<String> ORDERED_VALID_WARM_ACTIONS = List.of("set_priority", "unfollow", "readonly", "downsample", "allocate", "migrate", "shrink", "forcemerge");
    public static final List<String> ORDERED_VALID_COLD_ACTIONS = List.of("set_priority", "unfollow", "readonly", "downsample", "searchable_snapshot", "allocate", "migrate", "freeze");
    public static final List<String> ORDERED_VALID_FROZEN_ACTIONS = List.of("unfollow", "searchable_snapshot");
    public static final List<String> ORDERED_VALID_DELETE_ACTIONS = List.of("wait_for_snapshot", "delete");
    static final Set<String> VALID_HOT_ACTIONS = Sets.newHashSet(ORDERED_VALID_HOT_ACTIONS);
    static final Set<String> VALID_WARM_ACTIONS = Sets.newHashSet(ORDERED_VALID_WARM_ACTIONS);
    static final Set<String> VALID_COLD_ACTIONS = Sets.newHashSet(ORDERED_VALID_COLD_ACTIONS);
    static final Set<String> VALID_FROZEN_ACTIONS = Sets.newHashSet(ORDERED_VALID_FROZEN_ACTIONS);
    static final Set<String> VALID_DELETE_ACTIONS = Sets.newHashSet(ORDERED_VALID_DELETE_ACTIONS);
    private static final Map<String, Set<String>> ALLOWED_ACTIONS = Map.of("hot", VALID_HOT_ACTIONS, "warm", VALID_WARM_ACTIONS, "cold", VALID_COLD_ACTIONS, "delete", VALID_DELETE_ACTIONS, "frozen", VALID_FROZEN_ACTIONS);
    static final Set<String> HOT_ACTIONS_THAT_REQUIRE_ROLLOVER = Set.of("readonly", "shrink", "forcemerge", "downsample", "searchable_snapshot");
    public static final Set<String> ACTIONS_CANNOT_FOLLOW_SEARCHABLE_SNAPSHOT = Collections.unmodifiableSet(new LinkedHashSet<String>(List.of("forcemerge", "freeze", "shrink", "downsample")));

    private TimeseriesLifecycleType() {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public List<Phase> getOrderedPhases(Map<String, Phase> phases) {
        ArrayList<Phase> orderedPhases = new ArrayList<Phase>(ORDERED_VALID_PHASES.size());
        for (String phaseName : ORDERED_VALID_PHASES) {
            HashMap<String, LifecycleAction> actionMap;
            Phase phase = phases.get(phaseName);
            if (phase == null) continue;
            Map<String, LifecycleAction> actions = phase.getActions();
            if (!actions.containsKey("unfollow") && (actions.containsKey("rollover") || actions.containsKey("shrink") || actions.containsKey("searchable_snapshot") || actions.containsKey("downsample"))) {
                actionMap = new HashMap<String, LifecycleAction>(phase.getActions());
                actionMap.put("unfollow", UnfollowAction.INSTANCE);
                phase = new Phase(phase.getName(), phase.getMinimumAge(), actionMap);
            }
            if (TimeseriesLifecycleType.shouldInjectMigrateStepForPhase(phase)) {
                actionMap = new HashMap<String, LifecycleAction>(phase.getActions());
                actionMap.put("migrate", MigrateAction.ENABLED);
                phase = new Phase(phase.getName(), phase.getMinimumAge(), actionMap);
            }
            orderedPhases.add(phase);
        }
        return orderedPhases;
    }

    public static boolean shouldInjectMigrateStepForPhase(Phase phase) {
        if (!ALLOWED_ACTIONS.containsKey(phase.getName())) {
            return false;
        }
        if (phase.getActions().get("searchable_snapshot") != null) {
            return false;
        }
        if (!ALLOWED_ACTIONS.get(phase.getName()).contains("migrate")) {
            return false;
        }
        return phase.getActions().get("migrate") == null;
    }

    @Override
    public List<LifecycleAction> getOrderedActions(Phase phase) {
        Map<String, LifecycleAction> actions = phase.getActions();
        return switch (phase.getName()) {
            case HOT_PHASE -> ORDERED_VALID_HOT_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).toList();
            case WARM_PHASE -> ORDERED_VALID_WARM_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).toList();
            case COLD_PHASE -> ORDERED_VALID_COLD_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).toList();
            case FROZEN_PHASE -> ORDERED_VALID_FROZEN_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).toList();
            case DELETE_PHASE -> ORDERED_VALID_DELETE_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).toList();
            default -> throw new IllegalArgumentException("lifecycle type [timeseries] does not support phase [" + phase.getName() + "]");
        };
    }

    @Override
    public void validate(Collection<Phase> phases) {
        phases.forEach(phase -> {
            if (!ALLOWED_ACTIONS.containsKey(phase.getName())) {
                throw new IllegalArgumentException("Timeseries lifecycle does not support phase [" + phase.getName() + "]");
            }
            phase.getActions().forEach((actionName, action) -> {
                if (!ALLOWED_ACTIONS.get(phase.getName()).contains(actionName)) {
                    throw new IllegalArgumentException("invalid action [" + actionName + "] defined in phase [" + phase.getName() + "]");
                }
            });
        });
        String invalidHotPhaseActions = phases.stream().filter(phase -> HOT_PHASE.equals(phase.getName())).filter(phase -> !phase.getActions().containsKey("rollover")).flatMap(phase -> Sets.intersection(phase.getActions().keySet(), HOT_ACTIONS_THAT_REQUIRE_ROLLOVER).stream()).collect(Collectors.joining(", "));
        if (Strings.hasText(invalidHotPhaseActions)) {
            throw new IllegalArgumentException("the [" + invalidHotPhaseActions + "] action(s) may not be used in the [hot] phase without an accompanying [rollover] action");
        }
        String phasesWithConflictingMigrationActions = phases.stream().filter(phase -> phase.getActions().containsKey("migrate") && ((MigrateAction)phase.getActions().get("migrate")).isEnabled() && phase.getActions().containsKey("allocate") && TimeseriesLifecycleType.definesAllocationRules((AllocateAction)phase.getActions().get("allocate"))).map(Phase::getName).collect(Collectors.joining(","));
        if (Strings.hasText(phasesWithConflictingMigrationActions)) {
            throw new IllegalArgumentException("phases [" + phasesWithConflictingMigrationActions + "] specify an enabled migrate action and an allocate action with allocation rules. specify only a single data migration in each phase");
        }
        TimeseriesLifecycleType.validateActionsFollowingSearchableSnapshot(phases);
        TimeseriesLifecycleType.validateAllSearchableSnapshotActionsUseSameRepository(phases);
        TimeseriesLifecycleType.validateFrozenPhaseHasSearchableSnapshotAction(phases);
        TimeseriesLifecycleType.validateDownsamplingIntervals(phases);
        TimeseriesLifecycleType.validateReplicateFor(phases);
    }

    static void validateActionsFollowingSearchableSnapshot(Collection<Phase> phases) {
        String phasesDefiningIllegalActions;
        Optional<Phase> hotPhaseWithSearchableSnapshot = phases.stream().filter(phase -> phase.getName().equals(HOT_PHASE)).filter(phase -> phase.getActions().containsKey("searchable_snapshot")).findAny();
        ArrayList<Phase> phasesFollowingSearchableSnapshot = new ArrayList<Phase>(phases.size());
        if (hotPhaseWithSearchableSnapshot.isPresent()) {
            for (Phase phase2 : phases) {
                if (phase2.getName().equals(HOT_PHASE)) continue;
                phasesFollowingSearchableSnapshot.add(phase2);
            }
        } else {
            Optional<Phase> coldPhaseWithSearchableSnapshot = phases.stream().filter(phase -> phase.getName().equals(COLD_PHASE)).filter(phase -> phase.getActions().containsKey("searchable_snapshot")).findAny();
            if (coldPhaseWithSearchableSnapshot.isPresent()) {
                for (Phase phase3 : phases) {
                    if (!phase3.getName().equals(FROZEN_PHASE)) continue;
                    phasesFollowingSearchableSnapshot.add(phase3);
                    break;
                }
            }
        }
        if (Strings.hasText(phasesDefiningIllegalActions = phasesFollowingSearchableSnapshot.stream().filter(phase -> !Collections.disjoint(ACTIONS_CANNOT_FOLLOW_SEARCHABLE_SNAPSHOT, phase.getActions().keySet())).map(Phase::getName).collect(Collectors.joining(",")))) {
            throw new IllegalArgumentException("phases [" + phasesDefiningIllegalActions + "] define one or more of " + String.valueOf(ACTIONS_CANNOT_FOLLOW_SEARCHABLE_SNAPSHOT) + " actions which are not allowed after a managed index is mounted as a searchable snapshot");
        }
    }

    static void validateAllSearchableSnapshotActionsUseSameRepository(Collection<Phase> phases) {
        Set allRepos = phases.stream().flatMap(phase -> phase.getActions().entrySet().stream()).filter(e -> ((String)e.getKey()).equals("searchable_snapshot")).map(Map.Entry::getValue).map(action -> (SearchableSnapshotAction)action).map(SearchableSnapshotAction::getSnapshotRepository).collect(Collectors.toSet());
        if (allRepos.size() > 1) {
            throw new IllegalArgumentException("policy specifies [searchable_snapshot] action multiple times with differing repositories " + String.valueOf(allRepos) + ", the same repository must be used for all searchable snapshot actions");
        }
    }

    public static String validateMonotonicallyIncreasingPhaseTimings(Collection<Phase> phases) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        HashSet invalidPhases = new HashSet();
        for (int i = 0; i < ORDERED_VALID_PHASES.size(); ++i) {
            Phase phase;
            String phaseName = ORDERED_VALID_PHASES.get(i);
            Optional<Phase> maybePhase = phases.stream().filter(p -> phaseName.equals(p.getName())).filter(p -> p.getMinimumAge() != null && !p.getMinimumAge().equals(TimeValue.ZERO)).findFirst();
            if (!maybePhase.isPresent() || invalidPhases.contains((phase = maybePhase.get()).getName())) continue;
            TimeValue phaseMinAge = phase.getMinimumAge();
            HashSet<String> followingPhases = new HashSet<String>(ORDERED_VALID_PHASES.subList(i + 1, ORDERED_VALID_PHASES.size()));
            Set<Phase> phasesWithBadAges = phases.stream().filter(p -> followingPhases.contains(p.getName())).filter(p -> p.getMinimumAge() != null && !p.getMinimumAge().equals(TimeValue.ZERO)).filter(p -> p.getMinimumAge().compareTo(phaseMinAge) < 0).collect(Collectors.toSet());
            if (phasesWithBadAges.size() <= 0) continue;
            phasesWithBadAges.forEach(p -> invalidPhases.add(p.getName()));
            Iterator it = phasesWithBadAges.iterator();
            Phase badPhase = (Phase)it.next();
            Object error = "Your policy is configured to run the " + badPhase.getName() + " phase (min_age: " + String.valueOf(badPhase.getMinimumAge()) + ")";
            if (phasesWithBadAges.size() > 1) {
                while (it.hasNext()) {
                    badPhase = (Phase)it.next();
                    error = (String)error + ", the " + badPhase.getName() + " phase (min_age: " + String.valueOf(badPhase.getMinimumAge()) + ")";
                }
                StringBuilder builder = new StringBuilder();
                int last_comma_index = ((String)error).lastIndexOf(44);
                builder.append((CharSequence)error, 0, last_comma_index);
                builder.append(" and");
                builder.append(((String)error).substring(last_comma_index + 1));
                error = builder.toString();
            }
            error = (String)error + " before the " + phaseName + " phase (min_age: " + String.valueOf(phase.getMinimumAge()) + "). You should change the phase timing so that the phases will execute in the order of hot, warm, then cold.";
            errors.add((CallSite)error);
        }
        return Strings.collectionToCommaDelimitedString(errors);
    }

    static void validateFrozenPhaseHasSearchableSnapshotAction(Collection<Phase> phases) {
        Optional<Phase> maybeFrozenPhase = phases.stream().filter(p -> FROZEN_PHASE.equals(p.getName())).findFirst();
        maybeFrozenPhase.ifPresent(p -> {
            if (!p.getActions().containsKey("searchable_snapshot")) {
                throw new IllegalArgumentException("policy specifies the [frozen] phase without a corresponding [searchable_snapshot] action, but a searchable snapshot action is required in the frozen phase");
            }
        });
    }

    static void validateDownsamplingIntervals(Collection<Phase> phases) {
        Map<String, Phase> phasesWithDownsamplingActions = phases.stream().filter(phase -> phase.getActions().containsKey("downsample")).collect(Collectors.toMap(Phase::getName, Function.identity()));
        if (phasesWithDownsamplingActions.size() < 2) {
            return;
        }
        List<Phase> orderedPhases = INSTANCE.getOrderedPhases(phasesWithDownsamplingActions);
        List<Tuple> downsampleActions = orderedPhases.stream().map(phase -> Tuple.tuple(phase.getName(), (DownsampleAction)phase.getActions().get("downsample"))).toList();
        Tuple firstDownsample = downsampleActions.get(0);
        for (int i = 1; i < downsampleActions.size(); ++i) {
            long secondMillis;
            Tuple secondDownsample = downsampleActions.get(i);
            DateHistogramInterval firstInterval = ((DownsampleAction)firstDownsample.v2()).fixedInterval();
            DateHistogramInterval secondInterval = ((DownsampleAction)secondDownsample.v2()).fixedInterval();
            long firstMillis = firstInterval.estimateMillis();
            if (firstMillis >= (secondMillis = secondInterval.estimateMillis())) {
                throw new IllegalArgumentException("Downsampling interval [" + String.valueOf(secondInterval) + "] for phase [" + (String)secondDownsample.v1() + "] must be greater than the interval [" + String.valueOf(firstInterval) + "] for phase [" + (String)firstDownsample.v1() + "]");
            }
            if (secondMillis % firstMillis != 0L) {
                throw new IllegalArgumentException("Downsampling interval [" + String.valueOf(secondInterval) + "] for phase [" + (String)secondDownsample.v1() + "] must be a multiple of the interval [" + String.valueOf(firstInterval) + "] for phase [" + (String)firstDownsample.v1() + "]");
            }
            firstDownsample = secondDownsample;
        }
    }

    static void validateReplicateFor(Collection<Phase> phases) {
        Map<String, Phase> phasesWithSearchableSnapshotActions = phases.stream().filter(phase -> phase.getActions().containsKey("searchable_snapshot")).collect(Collectors.toMap(Phase::getName, Function.identity()));
        if (phasesWithSearchableSnapshotActions.isEmpty()) {
            return;
        }
        List<Phase> orderedPhases = INSTANCE.getOrderedPhases(phasesWithSearchableSnapshotActions);
        List<Tuple> searchableSnapshotActions = orderedPhases.stream().map(phase -> Tuple.tuple(phase.getName(), (SearchableSnapshotAction)phase.getActions().get("searchable_snapshot"))).toList();
        if (searchableSnapshotActions.size() > 1) {
            for (int i = 1; i < searchableSnapshotActions.size(); ++i) {
                boolean hasReplicateFor;
                Tuple phaseAndAction = searchableSnapshotActions.get(i);
                String phase2 = (String)phaseAndAction.v1();
                boolean bl = hasReplicateFor = ((SearchableSnapshotAction)phaseAndAction.v2()).getReplicateFor() != null;
                if (!hasReplicateFor) continue;
                throw new IllegalArgumentException(Strings.format("only the first searchable_snapshot action in a policy may specify 'replicate_for', but it was specified in the [%s] phase", phase2));
            }
        }
        String firstSearchableSnapshotPhase = (String)searchableSnapshotActions.get(0).v1();
        SearchableSnapshotAction firstSearchableSnapshotAction = (SearchableSnapshotAction)searchableSnapshotActions.get(0).v2();
        TimeValue firstReplicateFor = firstSearchableSnapshotAction.getReplicateFor();
        if (firstReplicateFor != null) {
            Map<String, Phase> allPhases = phases.stream().collect(Collectors.toMap(Phase::getName, Function.identity()));
            List<Phase> allPhasesInOrder = INSTANCE.getOrderedPhases(allPhases);
            TimeValue impliedMinAge = TimeValue.ZERO;
            for (Phase phase3 : allPhasesInOrder) {
                TimeValue phaseMinAge;
                TimeValue timeValue = phaseMinAge = phase3.getActions().containsKey("rollover") ? TimeValue.ZERO : phase3.getMinimumAge();
                if (phaseMinAge != TimeValue.ZERO) {
                    impliedMinAge = phaseMinAge;
                }
                if (!phase3.getName().equals(firstSearchableSnapshotPhase)) continue;
                break;
            }
            boolean afterReplicatorFor = false;
            for (Phase phase4 : allPhasesInOrder) {
                if (phase4.getName().equals(firstSearchableSnapshotPhase)) {
                    afterReplicatorFor = true;
                    continue;
                }
                if (!afterReplicatorFor) continue;
                TimeValue phaseMinAge = phase4.getMinimumAge();
                long minAgeDeltaMillis = phaseMinAge.millis() - impliedMinAge.millis();
                if (phaseMinAge == TimeValue.ZERO || minAgeDeltaMillis >= firstReplicateFor.millis()) continue;
                throw new IllegalArgumentException(Strings.format("The time a searchable snapshot is replicated in replicate_for [%s] may not exceed the time until the next phase is configured to begin. Based on the min_age [%s] of the [%s] phase, the maximum time the snapshot can be replicated is [%s].", firstReplicateFor, phaseMinAge, phase4.getName(), TimeValue.timeValueMillis(minAgeDeltaMillis).toString()));
            }
        }
    }

    private static boolean definesAllocationRules(AllocateAction action) {
        return !action.getRequire().isEmpty() || !action.getInclude().isEmpty() || !action.getExclude().isEmpty();
    }
}

