/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.Phase;

public class PhaseExecutionInfo
implements ToXContentObject,
Writeable {
    private static final ParseField POLICY_NAME_FIELD = new ParseField("policy", new String[0]);
    private static final ParseField PHASE_DEFINITION_FIELD = new ParseField("phase_definition", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    private static final ParseField MODIFIED_DATE_IN_MILLIS_FIELD = new ParseField("modified_date_in_millis", new String[0]);
    private static final ConstructingObjectParser<PhaseExecutionInfo, String> PARSER = new ConstructingObjectParser<PhaseExecutionInfo, String>("phase_execution_info", false, (a, name) -> new PhaseExecutionInfo((String)a[0], (Phase)a[1], (Long)a[2], (Long)a[3]));
    private final String policyName;
    private final Phase phase;
    private final long version;
    private final long modifiedDate;

    public static PhaseExecutionInfo parse(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    public PhaseExecutionInfo(String policyName, @Nullable Phase phase, long version, long modifiedDate) {
        this.policyName = policyName;
        this.phase = phase;
        this.version = version;
        this.modifiedDate = modifiedDate;
    }

    PhaseExecutionInfo(StreamInput in) throws IOException {
        this.policyName = in.readString();
        this.phase = in.readOptionalWriteable(Phase::new);
        this.version = in.readVLong();
        this.modifiedDate = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.policyName);
        out.writeOptionalWriteable(this.phase);
        out.writeVLong(this.version);
        out.writeVLong(this.modifiedDate);
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public long getVersion() {
        return this.version;
    }

    public long getModifiedDate() {
        return this.modifiedDate;
    }

    public int hashCode() {
        return Objects.hash(this.policyName, this.phase, this.version, this.modifiedDate);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhaseExecutionInfo other = (PhaseExecutionInfo)obj;
        return Objects.equals(this.policyName, other.policyName) && Objects.equals(this.phase, other.phase) && Objects.equals(this.version, other.version) && Objects.equals(this.modifiedDate, other.modifiedDate);
    }

    public String toString() {
        return Strings.toString(this, false, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY_NAME_FIELD.getPreferredName(), this.policyName);
        if (this.phase != null) {
            builder.field(PHASE_DEFINITION_FIELD.getPreferredName(), this.phase);
        }
        builder.field(VERSION_FIELD.getPreferredName(), this.version);
        builder.timestampFieldsFromUnixEpochMillis(MODIFIED_DATE_IN_MILLIS_FIELD.getPreferredName(), "modified_date", this.modifiedDate);
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Phase::parse, PHASE_DEFINITION_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), MODIFIED_DATE_IN_MILLIS_FIELD);
    }
}

