/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.List;
import java.util.Map;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;

@ServerlessScope(value=Scope.INTERNAL)
public class RestTemplatesAction
extends AbstractCatAction {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cat/templates"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/templates/{name}"));
    }

    @Override
    public String getName() {
        return "cat_templates_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/templates\n");
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(RestRequest request, NodeClient client) {
        String matchPattern = request.hasParam("name") ? request.param("name") : null;
        GetIndexTemplatesRequest getIndexTemplatesRequest = matchPattern == null ? new GetIndexTemplatesRequest(new String[0]) : new GetIndexTemplatesRequest(matchPattern);
        getIndexTemplatesRequest.local(request.paramAsBoolean("local", getIndexTemplatesRequest.local()));
        getIndexTemplatesRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        GetComposableIndexTemplateAction.Request getComposableTemplatesRequest = new GetComposableIndexTemplateAction.Request(matchPattern);
        getComposableTemplatesRequest.local(request.paramAsBoolean("local", getComposableTemplatesRequest.local()));
        getComposableTemplatesRequest.masterNodeTimeout(RestUtils.getMasterNodeTimeout(request));
        return channel -> {
            ListenableFuture<GetIndexTemplatesResponse> getIndexTemplatesStep = new ListenableFuture<GetIndexTemplatesResponse>();
            client.admin().indices().getTemplates(getIndexTemplatesRequest, getIndexTemplatesStep);
            ListenableFuture getComposableTemplatesStep = new ListenableFuture();
            client.execute(GetComposableIndexTemplateAction.INSTANCE, getComposableTemplatesRequest, getComposableTemplatesStep.delegateResponse((l, e) -> {
                if (ExceptionsHelper.unwrapCause(e) instanceof ResourceNotFoundException) {
                    l.onResponse(new GetComposableIndexTemplateAction.Response(Map.of()));
                } else {
                    l.onFailure((Exception)e);
                }
            }));
            RestResponseListener<Table> tableListener = new RestResponseListener<Table>(channel){

                @Override
                public RestResponse buildResponse(Table table) throws Exception {
                    return RestTable.buildResponse(table, this.channel);
                }
            };
            getIndexTemplatesStep.addListener(tableListener.delegateFailureAndWrap((l, getIndexTemplatesResponse) -> getComposableTemplatesStep.addListener(l.delegateFailureAndWrap((ll, getComposableIndexTemplatesResponse) -> ActionListener.completeWith(ll, () -> this.buildTable(request, (GetIndexTemplatesResponse)getIndexTemplatesResponse, (GetComposableIndexTemplateAction.Response)getComposableIndexTemplatesResponse))))));
        };
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("name", "alias:n;desc:template name");
        table.addCell("index_patterns", "alias:t;desc:template index patterns");
        table.addCell("order", "alias:o,p;desc:template application order/priority number");
        table.addCell("version", "alias:v;desc:version");
        table.addCell("composed_of", "alias:c;desc:component templates comprising index template");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, GetIndexTemplatesResponse getIndexTemplatesResponse, GetComposableIndexTemplateAction.Response getComposableIndexTemplatesResponse) {
        Table table = this.getTableWithHeader(request);
        for (IndexTemplateMetadata indexTemplateMetadata : getIndexTemplatesResponse.getIndexTemplates()) {
            table.startRow();
            table.addCell(indexTemplateMetadata.name());
            table.addCell("[" + String.join((CharSequence)", ", indexTemplateMetadata.patterns()) + "]");
            table.addCell(indexTemplateMetadata.getOrder());
            table.addCell(indexTemplateMetadata.getVersion());
            table.addCell("");
            table.endRow();
        }
        for (Map.Entry entry : getComposableIndexTemplatesResponse.indexTemplates().entrySet()) {
            String name = (String)entry.getKey();
            ComposableIndexTemplate template = (ComposableIndexTemplate)entry.getValue();
            table.startRow();
            table.addCell(name);
            table.addCell("[" + String.join((CharSequence)", ", template.indexPatterns()) + "]");
            table.addCell(template.priorityOrZero());
            table.addCell(template.version());
            table.addCell("[" + String.join((CharSequence)", ", template.composedOf()) + "]");
            table.endRow();
        }
        return table;
    }
}

