/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice.multibindings;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.injection.guice.Binder;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.Module;
import org.elasticsearch.injection.guice.Provider;
import org.elasticsearch.injection.guice.TypeLiteral;
import org.elasticsearch.injection.guice.binder.LinkedBindingBuilder;
import org.elasticsearch.injection.guice.multibindings.Multibinder;
import org.elasticsearch.injection.guice.multibindings.RealElement;
import org.elasticsearch.injection.guice.spi.ProviderWithDependencies;
import org.elasticsearch.injection.guice.util.Types;

public abstract class MapBinder<K, V> {
    private MapBinder() {
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType) {
        TypeLiteral<K> keyType1 = TypeLiteral.get(keyType);
        TypeLiteral<V> valueType1 = TypeLiteral.get(valueType);
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        return MapBinder.newMapBinder(binder, valueType1, Key.get(MapBinder.mapOf(keyType1, valueType1)), Key.get(MapBinder.mapOfProviderOf(keyType1, valueType1)), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyType1, valueType1)));
    }

    private static <K, V> TypeLiteral<Map<K, V>> mapOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), valueType.getType()));
    }

    private static <K, V> TypeLiteral<Map<K, Provider<V>>> mapOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), Types.newParameterizedType(Provider.class, new Type[]{valueType.getType()})));
    }

    private static <K, V> TypeLiteral<Map.Entry<K, Provider<V>>> entryOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, new Type[]{keyType.getType(), Types.providerOf(valueType.getType())}));
    }

    private static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Key<Map<K, Provider<V>>> providerMapKey, Multibinder<Map.Entry<K, Provider<V>>> entrySetBinder) {
        RealMapBinder<K, V> mapBinder = new RealMapBinder<K, V>(binder, valueType, mapKey, providerMapKey, entrySetBinder);
        binder.install(mapBinder);
        return mapBinder;
    }

    public abstract LinkedBindingBuilder<V> addBinding(K var1);

    public static final class RealMapBinder<K, V>
    extends MapBinder<K, V>
    implements Module {
        private final TypeLiteral<V> valueType;
        private final Key<Map<K, V>> mapKey;
        private final Key<Map<K, Provider<V>>> providerMapKey;
        private final Multibinder.RealMultibinder<Map.Entry<K, Provider<V>>> entrySetBinder;
        private Binder binder;

        private RealMapBinder(Binder binder, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Key<Map<K, Provider<V>>> providerMapKey, Multibinder<Map.Entry<K, Provider<V>>> entrySetBinder) {
            this.valueType = valueType;
            this.mapKey = mapKey;
            this.providerMapKey = providerMapKey;
            this.entrySetBinder = (Multibinder.RealMultibinder)entrySetBinder;
            this.binder = binder;
        }

        @Override
        public LinkedBindingBuilder<V> addBinding(K key) {
            Multibinder.checkNotNull(key, "key");
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            Key<V> valueKey = Key.get(this.valueType, new RealElement());
            this.entrySetBinder.addBinding().toInstance(new MapEntry<K, Provider<V>>(key, this.binder.getProvider(valueKey)));
            return this.binder.bind(valueKey);
        }

        @Override
        public void configure(Binder binder) {
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider = binder.getProvider(this.entrySetBinder.getSetKey());
            binder.bind(this.providerMapKey).toProvider(new MapBinderProviderWithDependencies<K, V>(this, entrySetProvider));
            Provider mapProvider = binder.getProvider(this.providerMapKey);
            binder.bind(this.mapKey).toProvider(() -> {
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry entry : ((Map)mapProvider.get()).entrySet()) {
                    Object value = ((Provider)entry.getValue()).get();
                    Object key = entry.getKey();
                    Multibinder.checkConfiguration(value != null, "Map injection failed due to null value for key \"%s\"", key);
                    map.put(key, value);
                }
                return Collections.unmodifiableMap(map);
            });
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public boolean equals(Object o) {
            return o instanceof RealMapBinder && ((RealMapBinder)o).mapKey.equals(this.mapKey);
        }

        public int hashCode() {
            return this.mapKey.hashCode();
        }

        private static final class MapEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private final V value;

            private MapEntry(K key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof Map.Entry && this.key.equals(((Map.Entry)obj).getKey()) && this.value.equals(((Map.Entry)obj).getValue());
            }

            @Override
            public int hashCode() {
                return 127 * ("key".hashCode() ^ this.key.hashCode()) + 127 * ("value".hashCode() ^ this.value.hashCode());
            }

            public String toString() {
                return "MapEntry(" + String.valueOf(this.key) + ", " + String.valueOf(this.value) + ")";
            }
        }

        public static class MapBinderProviderWithDependencies<K, V>
        implements ProviderWithDependencies<Map<K, Provider<V>>> {
            private Map<K, Provider<V>> providerMap;
            private final RealMapBinder binder;
            private final Provider<Set<Map.Entry<K, Provider<V>>>> provider;

            MapBinderProviderWithDependencies(RealMapBinder binder, Provider<Set<Map.Entry<K, Provider<V>>>> provider) {
                this.binder = binder;
                this.provider = provider;
            }

            @Inject
            public void initialize() {
                this.binder.binder = null;
                LinkedHashMap<K, Provider<V>> providerMapMutable = new LinkedHashMap<K, Provider<V>>();
                for (Map.Entry<K, Provider<V>> entry : this.provider.get()) {
                    Multibinder.checkConfiguration(providerMapMutable.put(entry.getKey(), entry.getValue()) == null, "Map injection failed due to duplicated key \"%s\"", entry.getKey());
                }
                this.providerMap = Collections.unmodifiableMap(providerMapMutable);
            }

            @Override
            public Map<K, Provider<V>> get() {
                return this.providerMap;
            }
        }
    }
}

