/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.util.Objects;
import org.elasticsearch.injection.guice.Initializable;
import org.elasticsearch.injection.guice.Provider;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.InternalContext;
import org.elasticsearch.injection.guice.internal.InternalFactory;
import org.elasticsearch.injection.guice.internal.SourceProvider;
import org.elasticsearch.injection.guice.spi.Dependency;

class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Initializable<Provider<? extends T>> initializable;
    private final Object source;

    InternalFactoryToProviderAdapter(Initializable<Provider<? extends T>> initializable) {
        this(initializable, SourceProvider.UNKNOWN_SOURCE);
    }

    InternalFactoryToProviderAdapter(Initializable<Provider<? extends T>> initializable, Object source) {
        this.initializable = Objects.requireNonNull(initializable, "provider");
        this.source = Objects.requireNonNull(source, "source");
    }

    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
        try {
            return errors.checkForNull(this.initializable.get(errors).get(), this.source, dependency);
        }
        catch (RuntimeException userException) {
            throw errors.withSource(this.source).errorInProvider(userException).toException();
        }
    }

    public String toString() {
        return this.initializable.toString();
    }
}

