/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.flattened;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.flattened.FlattenedFieldParser;
import org.elasticsearch.xcontent.XContentBuilder;

public class FlattenedFieldSyntheticWriterHelper {
    private static final String PATH_SEPARATOR = ".";
    private static final String PATH_SEPARATOR_PATTERN = "\\.";
    private final SortedKeyedValues sortedKeyedValues;

    public FlattenedFieldSyntheticWriterHelper(SortedKeyedValues sortedKeyedValues) {
        this.sortedKeyedValues = sortedKeyedValues;
    }

    private String concatPath(Prefix prefix, String leaf) {
        StringBuilder builder = new StringBuilder();
        for (String part : prefix.parts) {
            builder.append(part).append(PATH_SEPARATOR);
        }
        builder.append(leaf);
        return builder.toString();
    }

    public void write(XContentBuilder b) throws IOException {
        KeyValue curr = new KeyValue(this.sortedKeyedValues.next());
        ArrayList<String> values = new ArrayList<String>();
        Prefix openObjects = new Prefix();
        String lastScalarSingleLeaf = null;
        while (!curr.equals(KeyValue.EMPTY)) {
            KeyValue next = KeyValue.fromBytesRef(this.sortedKeyedValues.next());
            values.add(curr.value());
            while (curr.pathEquals(next)) {
                curr = next;
                next = KeyValue.fromBytesRef(this.sortedKeyedValues.next());
                values.add(curr.value());
            }
            Prefix startPrefix = curr.prefix.diff(openObjects);
            if (!startPrefix.parts.isEmpty() && startPrefix.parts.get(0).equals(lastScalarSingleLeaf)) {
                FlattenedFieldSyntheticWriterHelper.writeField(b, values, this.concatPath(startPrefix, curr.leaf()));
            } else {
                FlattenedFieldSyntheticWriterHelper.startObject(b, startPrefix.parts, openObjects.parts);
                FlattenedFieldSyntheticWriterHelper.writeField(b, values, curr.leaf());
                lastScalarSingleLeaf = curr.leaf();
            }
            int numObjectsToEnd = Prefix.numObjectsToEnd(openObjects.parts, next.prefix.parts);
            FlattenedFieldSyntheticWriterHelper.endObject(b, numObjectsToEnd, openObjects.parts);
            curr = next;
        }
    }

    private static void endObject(XContentBuilder b, int numObjectsToClose, List<String> openObjects) throws IOException {
        for (int i = 0; i < numObjectsToClose; ++i) {
            b.endObject();
            openObjects.remove(openObjects.size() - 1);
        }
    }

    private static void startObject(XContentBuilder b, List<String> objects, List<String> openObjects) throws IOException {
        for (String object : objects) {
            b.startObject(object);
            openObjects.add(object);
        }
    }

    private static void writeField(XContentBuilder b, List<String> values, String leaf) throws IOException {
        if (values.size() > 1) {
            b.field(leaf, (Collection<String>)values);
        } else {
            b.field(leaf, values.get(0));
        }
        values.clear();
    }

    public static interface SortedKeyedValues {
        public BytesRef next() throws IOException;
    }

    private record Prefix(List<String> parts) {
        Prefix() {
            this(new ArrayList<String>());
        }

        Prefix(String[] keyAsArray) {
            this(List.of(keyAsArray).subList(0, keyAsArray.length - 1));
        }

        private static int numObjectsToEnd(List<String> curr, List<String> next) {
            int i;
            for (i = 0; i < Math.min(curr.size(), next.size()) && curr.get(i).equals(next.get(i)); ++i) {
            }
            return Math.max(0, curr.size() - i);
        }

        private Prefix diff(Prefix other) {
            return Prefix.diff(this.parts, other.parts);
        }

        private static Prefix diff(List<String> a, List<String> b) {
            int i;
            assert (a.size() >= b.size());
            for (i = 0; i < b.size() && a.get(i).equals(b.get(i)); ++i) {
            }
            ArrayList<String> diff = new ArrayList<String>();
            while (i < a.size()) {
                diff.add(a.get(i));
                ++i;
            }
            return new Prefix(diff);
        }
    }

    private static class KeyValue {
        public static final KeyValue EMPTY = new KeyValue(null, new Prefix(), null);
        private final String value;
        private final Prefix prefix;
        private final String leaf;

        private KeyValue(String value, Prefix prefix, String leaf) {
            this.value = value;
            this.prefix = prefix;
            this.leaf = leaf;
        }

        KeyValue(BytesRef keyValue) {
            this(FlattenedFieldParser.extractKey(keyValue).utf8ToString().split(FlattenedFieldSyntheticWriterHelper.PATH_SEPARATOR_PATTERN), FlattenedFieldParser.extractValue(keyValue).utf8ToString());
        }

        private KeyValue(String[] key, String value) {
            this(value, new Prefix(key), key[key.length - 1]);
        }

        private static KeyValue fromBytesRef(BytesRef keyValue) {
            return keyValue == null ? EMPTY : new KeyValue(keyValue);
        }

        public String leaf() {
            return this.leaf;
        }

        public String value() {
            assert (this.value != null);
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.prefix, this.leaf);
        }

        public boolean pathEquals(KeyValue other) {
            return this.prefix.equals(other.prefix) && this.leaf.equals(other.leaf);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyValue other = (KeyValue)obj;
            return Objects.equals(this.value, other.value) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.leaf, other.leaf);
        }
    }
}

