/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;

public abstract class InferenceMetadataFieldsMapper
extends MetadataFieldMapper {
    public static final Setting<Boolean> USE_LEGACY_SEMANTIC_TEXT_FORMAT = Setting.boolSetting("index.mapping.semantic_text.use_legacy_format", false, Setting.Property.Final, Setting.Property.IndexScope, Setting.Property.InternalIndex);
    public static final String NAME = "_inference_fields";
    public static final String CONTENT_TYPE = "_inference_fields";

    protected InferenceMetadataFieldsMapper(MappedFieldType inferenceFieldType) {
        super(inferenceFieldType);
    }

    @Override
    protected String contentType() {
        return "_inference_fields";
    }

    @Override
    public InferenceMetadataFieldType fieldType() {
        return (InferenceMetadataFieldType)super.fieldType();
    }

    public static boolean isEnabled(Settings settings) {
        return IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(settings).onOrAfter(IndexVersions.INFERENCE_METADATA_FIELDS_BACKPORT) && USE_LEGACY_SEMANTIC_TEXT_FORMAT.get(settings) == false;
    }

    public static boolean isEnabled(MappingLookup mappingLookup) {
        return mappingLookup != null && mappingLookup.getMapping().getMetadataMapperByName("_inference_fields") instanceof InferenceMetadataFieldsMapper;
    }

    public static abstract class InferenceMetadataFieldType
    extends MappedFieldType {
        public InferenceMetadataFieldType() {
            super("_inference_fields", false, false, false, TextSearchInfo.NONE, Map.of());
        }

        public abstract ValueFetcher valueFetcher(MappingLookup var1, Function<Query, BitSetProducer> var2, IndexSearcher var3);
    }
}

