/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexWriteLoad;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record IndexMetadataStats(IndexWriteLoad indexWriteLoad, AverageShardSize averageShardSize) implements Writeable,
ToXContentFragment
{
    public static final ParseField WRITE_LOAD_FIELD = new ParseField("write_load", new String[0]);
    public static final ParseField AVERAGE_SIZE_FIELD = new ParseField("avg_size", new String[0]);
    private static final ConstructingObjectParser<IndexMetadataStats, Void> PARSER = new ConstructingObjectParser<IndexMetadataStats, Void>("index_metadata_stats_parser", false, (args, unused) -> new IndexMetadataStats((IndexWriteLoad)args[0], (AverageShardSize)args[1]));

    public IndexMetadataStats(IndexWriteLoad indexWriteLoad, long totalSizeInBytes, int numberOfShards) {
        this(indexWriteLoad, new AverageShardSize(totalSizeInBytes, numberOfShards));
    }

    public IndexMetadataStats(StreamInput in) throws IOException {
        this(new IndexWriteLoad(in), new AverageShardSize(in));
    }

    public IndexMetadataStats {
        Objects.requireNonNull(indexWriteLoad, "Expected a non null index write load");
        Objects.requireNonNull(averageShardSize, "Expected a non null average shard size");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.indexWriteLoad.writeTo(out);
        this.averageShardSize.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(WRITE_LOAD_FIELD.getPreferredName());
        this.indexWriteLoad.toXContent(builder, params);
        builder.endObject();
        builder.startObject(AVERAGE_SIZE_FIELD.getPreferredName());
        this.averageShardSize.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static IndexMetadataStats fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Nullable
    public static IndexMetadataStats fromStatsResponse(IndexMetadata indexMetadata, @Nullable IndicesStatsResponse indicesStatsResponse) {
        if (indicesStatsResponse == null) {
            return null;
        }
        IndexStats indexStats = indicesStatsResponse.getIndex(indexMetadata.getIndex().getName());
        if (indexStats == null) {
            return null;
        }
        long totalSizeInBytes = 0L;
        int shardsTookIntoAccountForSizeAvg = 0;
        int numberOfShards = indexMetadata.getNumberOfShards();
        IndexWriteLoad.Builder indexWriteLoadBuilder = IndexWriteLoad.builder(numberOfShards);
        Map<Integer, IndexShardStats> indexShards = indexStats.getIndexShards();
        for (IndexShardStats indexShardsStats : indexShards.values()) {
            ShardStats shardStats = Arrays.stream(indexShardsStats.getShards()).filter(stats -> stats.getShardRouting().primary()).findFirst().orElse(indexShardsStats.getAt(0));
            CommonStats commonStats = shardStats.getStats();
            IndexingStats.Stats indexingShardStats = commonStats.getIndexing().getTotal();
            indexWriteLoadBuilder.withShardWriteLoad(shardStats.getShardRouting().id(), indexingShardStats.getWriteLoad(), indexingShardStats.getTotalActiveTimeInMillis());
            totalSizeInBytes += commonStats.getDocs().getTotalSizeInBytes();
            ++shardsTookIntoAccountForSizeAvg;
        }
        return new IndexMetadataStats(indexWriteLoadBuilder.build(), new AverageShardSize(totalSizeInBytes, shardsTookIntoAccountForSizeAvg));
    }

    public IndexWriteLoad writeLoad() {
        return this.indexWriteLoad;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> IndexWriteLoad.fromXContent(p), WRITE_LOAD_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> AverageShardSize.fromXContent(p), AVERAGE_SIZE_FIELD);
    }

    public record AverageShardSize(long totalSizeInBytes, int numberOfShards) implements Writeable,
    ToXContentFragment
    {
        public static final ParseField TOTAL_SIZE_IN_BYTES_FIELD = new ParseField("total_size_in_bytes", new String[0]);
        public static final ParseField SHARD_COUNT_FIELD = new ParseField("shard_count", new String[0]);
        private static final ConstructingObjectParser<AverageShardSize, Void> PARSER = new ConstructingObjectParser<AverageShardSize, Void>("average_shard_size", false, (args, unused) -> new AverageShardSize((Long)args[0], (Integer)args[1]));

        public AverageShardSize {
            assert (numberOfShards > 0);
        }

        AverageShardSize(StreamInput in) throws IOException {
            this(in.readLong(), in.readInt());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.totalSizeInBytes);
            out.writeInt(this.numberOfShards);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(TOTAL_SIZE_IN_BYTES_FIELD.getPreferredName(), this.totalSizeInBytes);
            builder.field(SHARD_COUNT_FIELD.getPreferredName(), this.numberOfShards);
            return builder;
        }

        static AverageShardSize fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        public long getAverageSizeInBytes() {
            return this.totalSizeInBytes / (long)this.numberOfShards;
        }

        static {
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), TOTAL_SIZE_IN_BYTES_FIELD);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), SHARD_COUNT_FIELD);
        }
    }
}

