/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.ResettableValue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DataStreamFailureStore(@Nullable Boolean enabled, @Nullable DataStreamLifecycle lifecycle) implements SimpleDiffable<DataStreamFailureStore>,
ToXContentObject
{
    public static final String FAILURE_STORE = "failure_store";
    public static final String ENABLED = "enabled";
    public static final String LIFECYCLE = "lifecycle";
    private static final String EMPTY_FAILURE_STORE_ERROR_MESSAGE = "Failure store configuration should have at least one non-null configuration value.";
    public static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField LIFECYCLE_FIELD = new ParseField("lifecycle", new String[0]);
    public static final ConstructingObjectParser<DataStreamFailureStore, Void> PARSER = new ConstructingObjectParser<DataStreamFailureStore, Void>("failure_store", false, (args, unused) -> new DataStreamFailureStore((Boolean)args[0], (DataStreamLifecycle)args[1]));

    public DataStreamFailureStore {
        if (enabled == null && lifecycle == null) {
            throw new IllegalArgumentException(EMPTY_FAILURE_STORE_ERROR_MESSAGE);
        }
        assert (lifecycle == null || lifecycle.targetsFailureStore()) : "Invalid type for failures lifecycle";
    }

    public DataStreamFailureStore(StreamInput in) throws IOException {
        this(in.readOptionalBoolean(), in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19) ? in.readOptionalWriteable(DataStreamLifecycle::new) : null);
    }

    public static Diff<DataStreamFailureStore> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamFailureStore::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.enabled);
        if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19)) {
            out.writeOptionalWriteable(this.lifecycle);
        }
    }

    @Override
    public String toString() {
        return Strings.toString(this, true, true);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.enabled != null) {
            builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        }
        if (this.lifecycle != null) {
            builder.field(LIFECYCLE_FIELD.getPreferredName(), this.lifecycle);
        }
        builder.endObject();
        return builder;
    }

    public static DataStreamFailureStore fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Template template) {
        return new Builder(template);
    }

    public static Builder builder(DataStreamFailureStore failureStore) {
        return new Builder(failureStore);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ENABLED_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, unused) -> DataStreamLifecycle.failureLifecycleFromXContent(p), LIFECYCLE_FIELD);
    }

    public static class Builder {
        private Boolean enabled = null;
        private DataStreamLifecycle.Builder lifecycleBuilder = null;

        private Builder() {
        }

        private Builder(Template template) {
            if (template != null) {
                this.enabled = template.enabled.get();
                this.lifecycleBuilder = template.lifecycle.mapAndGet(l -> DataStreamLifecycle.builder(l));
            }
        }

        private Builder(DataStreamFailureStore failureStore) {
            if (failureStore != null) {
                this.enabled = failureStore.enabled;
                this.lifecycleBuilder = failureStore.lifecycle == null ? null : DataStreamLifecycle.builder(failureStore.lifecycle);
            }
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder enabled(ResettableValue<Boolean> enabled) {
            if (enabled.isDefined()) {
                this.enabled = enabled.get();
            }
            return this;
        }

        public Builder lifecycle(DataStreamLifecycle lifecycle) {
            this.lifecycleBuilder = lifecycle == null ? null : DataStreamLifecycle.builder(lifecycle);
            return this;
        }

        public Builder lifecycle(ResettableValue<DataStreamLifecycle.Template> lifecycle) {
            if (lifecycle.shouldReset()) {
                this.lifecycleBuilder = null;
            } else if (lifecycle.isDefined()) {
                if (this.lifecycleBuilder == null) {
                    this.lifecycleBuilder = DataStreamLifecycle.builder(lifecycle.get());
                } else {
                    this.lifecycleBuilder.composeTemplate(lifecycle.get());
                }
            }
            return this;
        }

        public Builder composeTemplate(Template failureStore) {
            this.enabled(failureStore.enabled());
            this.lifecycle(failureStore.lifecycle());
            return this;
        }

        @Nullable
        public DataStreamFailureStore build() {
            if (this.enabled == null && this.lifecycleBuilder == null) {
                return null;
            }
            return new DataStreamFailureStore(this.enabled, this.lifecycleBuilder == null ? null : this.lifecycleBuilder.build());
        }

        @Nullable
        public Template buildTemplate() {
            if (this.enabled == null && this.lifecycleBuilder == null) {
                return null;
            }
            return new Template(this.enabled, this.lifecycleBuilder == null ? null : this.lifecycleBuilder.buildTemplate());
        }
    }

    public record Template(ResettableValue<Boolean> enabled, ResettableValue<DataStreamLifecycle.Template> lifecycle) implements Writeable,
    ToXContentObject
    {
        public static final ConstructingObjectParser<Template, Void> PARSER = new ConstructingObjectParser<Template, Void>("failure_store_template", false, (args, unused) -> new Template(args[0] == null ? ResettableValue.undefined() : (ResettableValue)args[0], args[1] == null ? ResettableValue.undefined() : (ResettableValue)args[1]));

        public Template(@Nullable Boolean enabled, @Nullable DataStreamLifecycle.Template lifecycle) {
            this(ResettableValue.create(enabled), ResettableValue.create(lifecycle));
        }

        public Template {
            if (!enabled.isDefined() && !lifecycle.isDefined()) {
                throw new IllegalArgumentException(DataStreamFailureStore.EMPTY_FAILURE_STORE_ERROR_MESSAGE);
            }
            assert (lifecycle.get() == null || lifecycle.mapAndGet(l -> l.toDataStreamLifecycle().targetsFailureStore()).booleanValue()) : "Invalid lifecycle type in failure store template";
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            ResettableValue.write(out, this.enabled, StreamOutput::writeBoolean);
            if (out.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19)) {
                ResettableValue.write(out, this.lifecycle, (o, v) -> v.writeTo(o));
            }
        }

        public static Template read(StreamInput in) throws IOException {
            ResettableValue<Boolean> enabled = ResettableValue.read(in, StreamInput::readBoolean);
            ResettableValue<DataStreamLifecycle.Template> lifecycle = ResettableValue.undefined();
            if (in.getTransportVersion().onOrAfter(TransportVersions.INTRODUCE_FAILURES_LIFECYCLE_BACKPORT_8_19)) {
                lifecycle = ResettableValue.read(in, DataStreamLifecycle.Template::read);
            }
            return new Template(enabled, lifecycle);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.enabled.toXContent(builder, params, ENABLED_FIELD.getPreferredName());
            this.lifecycle.toXContent(builder, params, LIFECYCLE_FIELD.getPreferredName());
            builder.endObject();
            return builder;
        }

        public static Template fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        @Override
        public String toString() {
            return Strings.toString(this, true, true);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? ResettableValue.reset() : ResettableValue.create(p.booleanValue()), ENABLED_FIELD, ObjectParser.ValueType.BOOLEAN_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? ResettableValue.reset() : ResettableValue.create(DataStreamLifecycle.Template.failuresLifecycleTemplateFromXContent(p)), LIFECYCLE_FIELD, ObjectParser.ValueType.OBJECT_OR_NULL);
        }
    }
}

