/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.PutUserResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutUserRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String email;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final String fullName;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String password;
    @Nullable
    private final String passwordHash;
    @Nullable
    private final Refresh refresh;
    private final List<String> roles;
    private final String username;
    public static final JsonpDeserializer<PutUserRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutUserRequest::setupPutUserRequestDeserializer);
    public static final Endpoint<PutUserRequest, PutUserResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutUserRequest, PutUserResponse>("es/security.put_user", request -> "PUT", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _username = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("username", request.username);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutUserResponse._DESERIALIZER);

    private PutUserRequest(Builder builder) {
        this.email = builder.email;
        this.enabled = builder.enabled;
        this.fullName = builder.fullName;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.password = builder.password;
        this.passwordHash = builder.passwordHash;
        this.refresh = builder.refresh;
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
    }

    public static PutUserRequest of(Function<Builder, ObjectBuilder<PutUserRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String email() {
        return this.email;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final String fullName() {
        return this.fullName;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final String passwordHash() {
        return this.passwordHash;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled);
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.passwordHash != null) {
            generator.writeKey("password_hash");
            generator.write(this.passwordHash);
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutUserRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::email, JsonpDeserializer.stringDeserializer(), "email");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::passwordHash, JsonpDeserializer.stringDeserializer(), "password_hash");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutUserRequest> {
        @Nullable
        private String email;
        @Nullable
        private Boolean enabled;
        @Nullable
        private String fullName;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String password;
        @Nullable
        private String passwordHash;
        @Nullable
        private Refresh refresh;
        @Nullable
        private List<String> roles;
        private String username;

        public final Builder email(@Nullable String value) {
            this.email = value;
            return this;
        }

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder fullName(@Nullable String value) {
            this.fullName = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public final Builder passwordHash(@Nullable String value) {
            this.passwordHash = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutUserRequest build() {
            this._checkSingleUse();
            return new PutUserRequest(this);
        }
    }
}

