/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.xpack.core.XPackSettings;

public final class TransportTLSBootstrapCheck
implements BootstrapCheck {
    @Override
    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        assert (XPackSettings.SECURITY_ENABLED.get(context.settings()).booleanValue()) : "Bootstrap check should not be installed unless security is enabled";
        if (!XPackSettings.TRANSPORT_SSL_ENABLED.get(context.settings()).booleanValue()) {
            return BootstrapCheck.BootstrapCheckResult.failure("Transport SSL must be enabled if security is enabled. Please set [xpack.security.transport.ssl.enabled] to [true] or disable security by setting [xpack.security.enabled] to [false]");
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    @Override
    public ReferenceDocs referenceDocs() {
        return ReferenceDocs.BOOTSTRAP_CHECK_TLS;
    }
}

