/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.UpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetJobModelSnapshotsUpgradeStatsAction
extends ActionType<Response> {
    public static final GetJobModelSnapshotsUpgradeStatsAction INSTANCE = new GetJobModelSnapshotsUpgradeStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/model_snapshots/upgrade/stats/get";
    public static final String ALL = "_all";
    private static final String STATE = "state";
    private static final String NODE = "node";
    private static final String ASSIGNMENT_EXPLANATION = "assignment_explanation";
    public static final ParseField RESULTS_FIELD = new ParseField("model_snapshot_upgrades", new String[0]);
    public static String TYPE = "model_snapshot_upgrade";

    private GetJobModelSnapshotsUpgradeStatsAction() {
        super(NAME);
    }

    public static class Response
    extends AbstractGetResourcesResponse<JobModelSnapshotUpgradeStats>
    implements ToXContentObject {
        public Response(QueryPage<JobModelSnapshotUpgradeStats> upgradeStats) {
            super(upgradeStats);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public QueryPage<JobModelSnapshotUpgradeStats> getResponse() {
            return this.getResources();
        }

        @Override
        protected Writeable.Reader<JobModelSnapshotUpgradeStats> getReader() {
            return JobModelSnapshotUpgradeStats::new;
        }

        public static class JobModelSnapshotUpgradeStats
        implements ToXContentObject,
        Writeable {
            private final String jobId;
            private final String snapshotId;
            private final SnapshotUpgradeState upgradeState;
            @Nullable
            private final DiscoveryNode node;
            @Nullable
            private final String assignmentExplanation;

            public JobModelSnapshotUpgradeStats(String jobId, String snapshotId, SnapshotUpgradeState upgradeState, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation) {
                this.jobId = Objects.requireNonNull(jobId);
                this.snapshotId = Objects.requireNonNull(snapshotId);
                this.upgradeState = Objects.requireNonNull(upgradeState);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
            }

            JobModelSnapshotUpgradeStats(StreamInput in) throws IOException {
                this.jobId = in.readString();
                this.snapshotId = in.readString();
                this.upgradeState = SnapshotUpgradeState.fromStream(in);
                this.node = in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
            }

            public String getJobId() {
                return this.jobId;
            }

            public String getSnapshotId() {
                return this.snapshotId;
            }

            public SnapshotUpgradeState getUpgradeState() {
                return this.upgradeState;
            }

            public DiscoveryNode getNode() {
                return this.node;
            }

            public String getAssignmentExplanation() {
                return this.assignmentExplanation;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(Job.ID.getPreferredName(), this.jobId);
                builder.field(UpgradeJobModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName(), this.snapshotId);
                builder.field(GetJobModelSnapshotsUpgradeStatsAction.STATE, this.upgradeState.toString());
                if (this.node != null) {
                    builder.startObject(GetJobModelSnapshotsUpgradeStatsAction.NODE);
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry<String, String> entry : this.node.getAttributes().entrySet()) {
                        if (!entry.getKey().startsWith("ml.")) continue;
                        builder.field(entry.getKey(), entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field(GetJobModelSnapshotsUpgradeStatsAction.ASSIGNMENT_EXPLANATION, this.assignmentExplanation);
                }
                builder.endObject();
                return builder;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.jobId);
                out.writeString(this.snapshotId);
                this.upgradeState.writeTo(out);
                out.writeOptionalWriteable(this.node);
                out.writeOptionalString(this.assignmentExplanation);
            }

            public int hashCode() {
                return Objects.hash(this.jobId, this.snapshotId, this.upgradeState, this.node, this.assignmentExplanation);
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                JobModelSnapshotUpgradeStats other = (JobModelSnapshotUpgradeStats)obj;
                return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.upgradeState, other.upgradeState) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation);
            }

            public static Builder builder(String jobId, String snapshotId) {
                return new Builder(jobId, snapshotId);
            }

            public static class Builder {
                private final String jobId;
                private final String snapshotId;
                private SnapshotUpgradeState upgradeState;
                private DiscoveryNode node;
                private String assignmentExplanation;

                public Builder(String jobId, String snapshotId) {
                    this.jobId = jobId;
                    this.snapshotId = snapshotId;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public String getSnapshotId() {
                    return this.snapshotId;
                }

                public Builder setUpgradeState(SnapshotUpgradeState upgradeState) {
                    this.upgradeState = Objects.requireNonNull(upgradeState);
                    return this;
                }

                public Builder setNode(DiscoveryNode node) {
                    this.node = node;
                    return this;
                }

                public Builder setAssignmentExplanation(String assignmentExplanation) {
                    this.assignmentExplanation = assignmentExplanation;
                    return this;
                }

                public JobModelSnapshotUpgradeStats build() {
                    return new JobModelSnapshotUpgradeStats(this.jobId, this.snapshotId, this.upgradeState, this.node, this.assignmentExplanation);
                }
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public static final String ALLOW_NO_MATCH = "allow_no_match";
        private final String jobId;
        private final String snapshotId;
        private boolean allowNoMatch = true;

        public Request(String jobId, String snapshotId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
            this.snapshotId = ExceptionsHelper.requireNonNull(snapshotId, UpgradeJobModelSnapshotAction.Request.SNAPSHOT_ID.getPreferredName());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobId = in.readString();
            this.snapshotId = in.readString();
            this.allowNoMatch = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeString(this.snapshotId);
            out.writeBoolean(this.allowNoMatch);
        }

        public String getJobId() {
            return this.jobId;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.snapshotId, this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.snapshotId, other.snapshotId) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, Strings.format("get_job_model_snapshot_upgrade_stats[%s:%s]", this.jobId, this.snapshotId), parentTaskId, headers);
        }
    }
}

