/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Objects;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractBooleanScriptFieldQuery;

public class BooleanScriptFieldTermQuery
extends AbstractBooleanScriptFieldQuery {
    private final boolean term;

    public BooleanScriptFieldTermQuery(Script script, BooleanFieldScript.LeafFactory leafFactory, String fieldName, boolean term) {
        super(script, leafFactory, fieldName);
        this.term = term;
    }

    @Override
    protected boolean matches(int trues, int falses) {
        if (this.term) {
            return trues > 0;
        }
        return falses > 0;
    }

    @Override
    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return Boolean.toString(this.term);
        }
        return this.fieldName() + ":" + this.term;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BooleanScriptFieldTermQuery other = (BooleanScriptFieldTermQuery)obj;
        return this.term == other.term;
    }

    boolean term() {
        return this.term;
    }
}

