/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public record ReservedStateVersion(Long version, Version compatibleWith) implements Writeable
{
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField COMPATIBILITY = new ParseField("compatibility", new String[0]);
    private static final ConstructingObjectParser<ReservedStateVersion, Void> PARSER = new ConstructingObjectParser("reserved_cluster_state_version_metadata", a -> {
        Long updateId = Long.parseLong((String)a[0]);
        Version minCompatVersion = Version.fromString((String)a[1]);
        return new ReservedStateVersion(updateId, minCompatVersion);
    });

    public static ReservedStateVersion parse(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public Version minCompatibleVersion() {
        return this.compatibleWith;
    }

    public static ReservedStateVersion readFrom(StreamInput input) throws IOException {
        return new ReservedStateVersion(input.readLong(), Version.readVersion(input));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version());
        Version.writeVersion(this.compatibleWith(), out);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), COMPATIBILITY);
    }
}

