/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.elasticsearch.common.xcontent.ChunkedToXContentBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public interface ChunkedToXContent {
    public static final ChunkedToXContent EMPTY = params -> Collections.emptyIterator();

    public static ChunkedToXContentBuilder builder(ToXContent.Params params) {
        return new ChunkedToXContentBuilder(params);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params var1);

    default public Iterator<? extends ToXContent> toXContentChunkedV7(ToXContent.Params params) {
        return this.toXContentChunked(params);
    }

    public static ToXContent wrapAsToXContent(final ChunkedToXContent chunkedToXContent) {
        return new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                Iterator<? extends ToXContent> serialization = chunkedToXContent.toXContentChunked(params);
                while (serialization.hasNext()) {
                    serialization.next().toXContent(builder, params);
                }
                return builder;
            }

            @Override
            public boolean isFragment() {
                return chunkedToXContent.isFragment();
            }
        };
    }

    default public boolean isFragment() {
        return true;
    }
}

