/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SnapshotShardFailure
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String nodeId;
    private final String reason;
    private final int shardId;
    private final String indexUuid;
    private final String status;
    public static final JsonpDeserializer<SnapshotShardFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotShardFailure::setupSnapshotShardFailureDeserializer);

    private SnapshotShardFailure(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.nodeId = builder.nodeId;
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.shardId = ApiTypeHelper.requireNonNull(builder.shardId, (Object)this, "shardId", 0);
        this.indexUuid = ApiTypeHelper.requireNonNull(builder.indexUuid, this, "indexUuid");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
    }

    public static SnapshotShardFailure of(Function<Builder, ObjectBuilder<SnapshotShardFailure>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String nodeId() {
        return this.nodeId;
    }

    public final String reason() {
        return this.reason;
    }

    public final int shardId() {
        return this.shardId;
    }

    public final String indexUuid() {
        return this.indexUuid;
    }

    public final String status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (this.nodeId != null) {
            generator.writeKey("node_id");
            generator.write(this.nodeId);
        }
        generator.writeKey("reason");
        generator.write(this.reason);
        generator.writeKey("shard_id");
        generator.write(this.shardId);
        generator.writeKey("index_uuid");
        generator.write(this.indexUuid);
        generator.writeKey("status");
        generator.write(this.status);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSnapshotShardFailureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::shardId, JsonpDeserializer.integerDeserializer(), "shard_id");
        op.add(Builder::indexUuid, JsonpDeserializer.stringDeserializer(), "index_uuid");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotShardFailure> {
        private String index;
        @Nullable
        private String nodeId;
        private String reason;
        private Integer shardId;
        private String indexUuid;
        private String status;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder nodeId(@Nullable String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder shardId(int value) {
            this.shardId = value;
            return this;
        }

        public final Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        public final Builder status(String value) {
            this.status = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotShardFailure build() {
            this._checkSingleUse();
            return new SnapshotShardFailure(this);
        }
    }
}

