/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PipelineConfig
implements JsonpSerializable {
    @Nullable
    private final String description;
    @Nullable
    private final Long version;
    private final List<Processor> processors;
    public static final JsonpDeserializer<PipelineConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineConfig::setupPipelineConfigDeserializer);

    private PipelineConfig(Builder builder) {
        this.description = builder.description;
        this.version = builder.version;
        this.processors = ApiTypeHelper.unmodifiableRequired(builder.processors, (Object)this, "processors");
    }

    public static PipelineConfig of(Function<Builder, ObjectBuilder<PipelineConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    public final List<Processor> processors() {
        return this.processors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (ApiTypeHelper.isDefined(this.processors)) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (Processor item0 : this.processors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPipelineConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(Processor._DESERIALIZER), "processors");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PipelineConfig> {
        @Nullable
        private String description;
        @Nullable
        private Long version;
        private List<Processor> processors;

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder processors(List<Processor> list) {
            this.processors = Builder._listAddAll(this.processors, list);
            return this;
        }

        public final Builder processors(Processor value, Processor ... values) {
            this.processors = Builder._listAdd(this.processors, value, values);
            return this;
        }

        public final Builder processors(ProcessorVariant value, ProcessorVariant ... values) {
            this.processors = Builder._listAdd(this.processors, value._toProcessor(), new Processor[0]);
            for (ProcessorVariant v : values) {
                Builder._listAdd(this.processors, v._toProcessor(), new Processor[0]);
            }
            return this;
        }

        public final Builder processors(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processors(fn.apply(new Processor.Builder()).build(), new Processor[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PipelineConfig build() {
            this._checkSingleUse();
            return new PipelineConfig(this);
        }
    }
}

