/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class MatrixAggregation
extends AggregationBase
implements JsonpSerializable {
    private final List<String> fields;
    private final Map<String, Double> missing;

    protected MatrixAggregation(AbstractBuilder<?> builder) {
        this.fields = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.missing = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).missing);
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final Map<String, Double> missing() {
        return this.missing;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.missing)) {
            generator.writeKey("missing");
            generator.writeStartObject();
            for (Map.Entry entry : this.missing.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((Double)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMatrixAggregationDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(AbstractBuilder::missing, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "missing");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private List<String> fields;
        @Nullable
        private Map<String, Double> missing;

        public final BuilderT fields(List<String> list) {
            this.fields = AbstractBuilder._listAddAll(this.fields, list);
            return (BuilderT)this.self();
        }

        public final BuilderT fields(String value, String ... values) {
            this.fields = AbstractBuilder._listAdd(this.fields, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT missing(Map<String, Double> map) {
            this.missing = AbstractBuilder._mapPutAll(this.missing, map);
            return (BuilderT)this.self();
        }

        public final BuilderT missing(String key, Double value) {
            this.missing = AbstractBuilder._mapPut(this.missing, key, value);
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

