"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueInputType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _filter_editor_utils = require("./lib/filter_editor_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ValueInputTypeUI extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "getValueForNumberField", value => {
      if (typeof value === 'string') {
        const parsedValue = parseFloat(value);
        return isNaN(parsedValue) ? value : parsedValue;
      }
      return value;
    });
    (0, _defineProperty2.default)(this, "onBoolChange", event => {
      const boolValue = event.target.value === 'true';
      this.props.onChange(boolValue);
    });
    (0, _defineProperty2.default)(this, "onChange", event => {
      const params = event.target.value;
      this.props.onChange(params);
    });
    (0, _defineProperty2.default)(this, "onBlur", event => {
      if (this.props.onBlur) {
        const params = event.target.value;
        this.props.onBlur(params);
      }
    });
  }
  render() {
    var _this$props$value, _this$props$field$typ, _this$props$field;
    const value = (_this$props$value = this.props.value) !== null && _this$props$value !== void 0 ? _this$props$value : '';
    const type = (_this$props$field$typ = (_this$props$field = this.props.field) === null || _this$props$field === void 0 ? void 0 : _this$props$field.type) !== null && _this$props$field$typ !== void 0 ? _this$props$field$typ : 'string';
    let inputElement;
    switch (type) {
      case 'string':
        inputElement = /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          compressed: this.props.compressed,
          disabled: this.props.disabled,
          fullWidth: this.props.fullWidth,
          placeholder: this.props.placeholder,
          "aria-label": this.props.placeholder,
          value: value,
          onChange: this.onChange,
          isInvalid: !(0, _filter_editor_utils.validateParams)(value, this.props.field),
          controlOnly: this.props.controlOnly,
          className: this.props.className,
          "data-test-subj": this.props.dataTestSubj
        });
        break;
      case 'number':
      case 'number_range':
        inputElement = /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
          compressed: this.props.compressed,
          disabled: this.props.disabled,
          fullWidth: this.props.fullWidth,
          placeholder: this.props.placeholder,
          "aria-label": this.props.placeholder,
          value: this.getValueForNumberField(value),
          onChange: this.onChange,
          controlOnly: this.props.controlOnly,
          className: this.props.className,
          "data-test-subj": this.props.dataTestSubj
        });
        break;
      case 'date':
      case 'date_range':
        inputElement = /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          compressed: this.props.compressed,
          disabled: this.props.disabled,
          fullWidth: this.props.fullWidth,
          placeholder: this.props.placeholder,
          "aria-label": this.props.placeholder,
          value: value,
          onChange: this.onChange,
          onBlur: this.onBlur,
          isInvalid: this.props.isInvalid,
          controlOnly: this.props.controlOnly,
          className: this.props.className,
          "data-test-subj": this.props.dataTestSubj
        });
        break;
      case 'ip':
      case 'ip_range':
        inputElement = /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          fullWidth: this.props.fullWidth,
          disabled: this.props.disabled,
          placeholder: this.props.placeholder,
          "aria-label": this.props.placeholder,
          value: value,
          onChange: this.onChange,
          isInvalid: !(0, _lodash.isEmpty)(value) && !(0, _filter_editor_utils.validateParams)(value, this.props.field),
          controlOnly: this.props.controlOnly,
          className: this.props.className,
          compressed: this.props.compressed,
          "data-test-subj": this.props.dataTestSubj
        });
        break;
      case 'boolean':
        inputElement = /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
          options: [{
            value: undefined,
            text: this.props.placeholder
          }, {
            value: 'true',
            text: this.props.intl.formatMessage({
              id: 'unifiedSearch.filter.filterEditor.trueOptionLabel',
              defaultMessage: 'true'
            })
          }, {
            value: 'false',
            text: this.props.intl.formatMessage({
              id: 'unifiedSearch.filter.filterEditor.falseOptionLabel',
              defaultMessage: 'false'
            })
          }],
          value: value,
          onChange: this.onBoolChange,
          "aria-label": this.props.placeholder,
          className: this.props.className,
          fullWidth: this.props.fullWidth,
          compressed: this.props.compressed,
          "data-test-subj": this.props.dataTestSubj
        });
        break;
      default:
        break;
    }
    return inputElement;
  }
}
const ValueInputType = exports.ValueInputType = (0, _i18nReact.injectI18n)(ValueInputTypeUI);