"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedHistogramContainer = void 0;
Object.defineProperty(exports, "getBreakdownField", {
  enumerable: true,
  get: function () {
    return _local_storage_utils.getBreakdownField;
  }
});
Object.defineProperty(exports, "getChartHidden", {
  enumerable: true,
  get: function () {
    return _local_storage_utils.getChartHidden;
  }
});
Object.defineProperty(exports, "getTopPanelHeight", {
  enumerable: true,
  get: function () {
    return _local_storage_utils.getTopPanelHeight;
  }
});
Object.defineProperty(exports, "setBreakdownField", {
  enumerable: true,
  get: function () {
    return _local_storage_utils.setBreakdownField;
  }
});
Object.defineProperty(exports, "setChartHidden", {
  enumerable: true,
  get: function () {
    return _local_storage_utils.setChartHidden;
  }
});
Object.defineProperty(exports, "setTopPanelHeight", {
  enumerable: true,
  get: function () {
    return _local_storage_utils.setTopPanelHeight;
  }
});
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react = _interopRequireWildcard(require("react"));
var _local_storage_utils = require("./utils/local_storage_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const LazyUnifiedHistogramContainer = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./container'))));

/**
 * A resizable layout component with two panels that renders a histogram with a hits
 * counter in the top panel, and a main display (data table, etc.) in the bottom panel.
 */
const UnifiedHistogramContainer = exports.UnifiedHistogramContainer = (0, _sharedUxUtility.withSuspense)(LazyUnifiedHistogramContainer, /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, {
  delay: 300
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: "eui-fullHeight",
  alignItems: "center",
  justifyContent: "center",
  gutterSize: "none",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  size: "l"
}))));