"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanFlyoutBody = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _doc_viewer_span_overview = _interopRequireDefault(require("../../../doc_viewer_span_overview"));
var _doc_viewer_transaction_overview = _interopRequireDefault(require("../../../doc_viewer_transaction_overview"));
var _doc_viewer_table = _interopRequireDefault(require("../../../../../doc_viewer_table"));
var _doc_viewer_source = _interopRequireDefault(require("../../../../../doc_viewer_source"));
var _use_data_sources = require("../../../hooks/use_data_sources");
var _is_span = require("../helpers/is_span");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const tabIds = {
  OVERVIEW: 'unifiedDocViewerTracesSpanFlyoutOverview',
  TABLE: 'unifiedDocViewerTracesSpanFlyoutTable',
  JSON: 'unifiedDocViewerTracesSpanFlyoutJson'
};
const tabs = [{
  id: tabIds.OVERVIEW,
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.tabs.overview', {
    defaultMessage: 'Overview'
  })
}, {
  id: tabIds.TABLE,
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.tabs.table', {
    defaultMessage: 'Table'
  })
}, {
  id: tabIds.JSON,
  name: _i18n.i18n.translate('unifiedDocViewer.observability.traces.fullScreenWaterfall.tabs.json', {
    defaultMessage: 'JSON'
  })
}];
const SpanFlyoutBody = ({
  hit,
  loading,
  dataView
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabIds.OVERVIEW);
  const isSpan = (0, _is_span.isSpanHit)(hit);
  const {
    indexes
  } = (0, _use_data_sources.useDataSourcesContext)();
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = () => {
    return tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: tab.id,
      onClick: () => onSelectedTabChanged(tab.id),
      isSelected: tab.id === selectedTabId
    }, tab.name));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading || !hit ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 5
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s"
  }, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    isLoading: loading
  }, selectedTabId === tabIds.OVERVIEW && /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, isSpan ? /*#__PURE__*/_react.default.createElement(_doc_viewer_span_overview.default, {
    hit: hit,
    indexes: indexes,
    showWaterfall: false,
    showActions: false,
    dataView: dataView
  }) : /*#__PURE__*/_react.default.createElement(_doc_viewer_transaction_overview.default, {
    hit: hit,
    indexes: indexes,
    showWaterfall: false,
    showActions: false,
    dataView: dataView
  })), selectedTabId === tabIds.TABLE && /*#__PURE__*/_react.default.createElement(_doc_viewer_table.default, {
    hit: hit,
    dataView: dataView
  }), selectedTabId === tabIds.JSON && /*#__PURE__*/_react.default.createElement(_doc_viewer_source.default, {
    id: hit.id,
    index: hit.raw._index,
    dataView: dataView,
    esqlHit: hit,
    onRefresh: () => {}
    /* We're already passing the document in this case, so this refresh won't have a chance to run.
    It's handled the same way in src/platform/plugins/shared/unified_doc_viewer/public/plugin.tsx */
  }))));
};
exports.SpanFlyoutBody = SpanFlyoutBody;