"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFieldValue = exports.DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
var _uiTheme = require("@kbn/ui-theme");
var _plugin = require("../../plugin");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT = exports.DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT = 110;

// Keep in memory what field values were expanded by the user and restore this state when the user opens DocViewer again
const expandedFieldValuesSet = new Set();
const IgnoreWarning = /*#__PURE__*/_react2.default.memo(({
  rawValue,
  reason
}) => {
  const multiValue = Array.isArray(rawValue) && rawValue.length > 1;
  const getToolTipContent = () => {
    switch (reason) {
      case _discoverUtils.IgnoredReason.IGNORE_ABOVE:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiAboveTooltip', {
          defaultMessage: `One or more values in this field are too long and can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleAboveTooltip', {
          defaultMessage: `The value in this field is too long and can't be searched or filtered.`
        });
      case _discoverUtils.IgnoredReason.MALFORMED:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiMalformedTooltip', {
          defaultMessage: `This field has one or more malformed values that can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleMalformedTooltip', {
          defaultMessage: `The value in this field is malformed and can't be searched or filtered.`
        });
      case _discoverUtils.IgnoredReason.UNKNOWN:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiUnknownTooltip', {
          defaultMessage: `One or more values in this field were ignored by Elasticsearch and can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleUnknownTooltip', {
          defaultMessage: `The value in this field was ignored by Elasticsearch and can't be searched or filtered.`
        });
    }
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: getToolTipContent()
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center",
    css: (0, _react.css)`
          cursor: help;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "warning"
  }, multiValue ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.ignored.multiValueLabel', {
    defaultMessage: 'Contains ignored values'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.ignored.singleValueLabel', {
    defaultMessage: 'Ignored value'
  })))));
});
const TableFieldValue = ({
  formattedValue,
  field,
  rawValue,
  ignoreReason,
  isDetails,
  isLegacy,
  isHighlighted
}) => {
  var _containerRef$scrollH;
  const {
    uiSettings
  } = (0, _plugin.getUnifiedDocViewerServices)();
  const truncationHeight = isLegacy ? uiSettings.get(_discoverUtils.TRUNCATE_MAX_HEIGHT) : DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT;
  const [containerRef, setContainerRef] = (0, _react2.useState)(null);
  (0, _eui.useResizeObserver)(containerRef);
  const containerScrollHeight = (_containerRef$scrollH = containerRef === null || containerRef === void 0 ? void 0 : containerRef.scrollHeight) !== null && _containerRef$scrollH !== void 0 ? _containerRef$scrollH : 0;
  const [isValueExpanded, setIsValueExpanded] = (0, _react2.useState)(expandedFieldValuesSet.has(field));
  const isCollapsible = !isDetails && Boolean(rawValue) && truncationHeight > 0 && containerScrollHeight > 0 && containerScrollHeight > truncationHeight;
  const isCollapsed = isCollapsible && !isValueExpanded;
  const onToggleCollapse = (0, _react2.useCallback)(() => setIsValueExpanded(isExpandedPrev => {
    const isExpandedNext = !isExpandedPrev;
    if (isExpandedNext) {
      expandedFieldValuesSet.add(field);
    } else {
      expandedFieldValuesSet.delete(field);
    }
    return isExpandedNext;
  }), [field, setIsValueExpanded]);
  const toggleButtonLabel = isCollapsed ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.viewMoreButton', {
    defaultMessage: 'View more'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.viewLessButton', {
    defaultMessage: 'View less'
  });
  const shouldTruncate = isCollapsible && isCollapsed;
  const valueElementId = `tableDocViewRow-${field}-value`;
  return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, null, ignoreReason && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(IgnoreWarning, {
    reason: ignoreReason,
    rawValue: rawValue
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    alignItems: "flexStart"
  }, isCollapsible && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.collapseButtonWrapper
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    iconType: isCollapsed ? 'plusInSquare' : 'minusInSquare',
    size: "xs",
    color: "primary",
    "data-test-subj": `toggleLongFieldValue-${field}`,
    title: toggleButtonLabel,
    "aria-label": toggleButtonLabel,
    "aria-expanded": !isCollapsed,
    "aria-controls": valueElementId,
    onClick: onToggleCollapse
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("div", {
    ref: setContainerRef,
    className: "kbnDocViewer__value",
    css: [styles.docViewerValue, isHighlighted && !isDetails && styles.docViewerValueHighlighted, shouldTruncate && styles.docViewerValueTruncated],
    id: valueElementId,
    "data-test-subj": valueElementId
    // Value returned from formatFieldValue is always sanitized
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: formattedValue
    }
  }))));
};
exports.TableFieldValue = TableFieldValue;
const styles = {
  docViewerValue: (0, _react.css)({
    wordBreak: 'break-all',
    wordWrap: 'break-word',
    whiteSpace: 'pre-wrap',
    lineHeight: _uiTheme.euiThemeVars.euiLineHeight,
    verticalAlign: 'top',
    '.euiDataGridRowCell__popover &': {
      fontSize: _uiTheme.euiThemeVars.euiFontSizeS
    }
  }),
  docViewerValueHighlighted: (0, _react.css)({
    fontWeight: _uiTheme.euiThemeVars.euiFontWeightBold
  }),
  docViewerValueTruncated: (0, _react.css)({
    overflow: 'hidden',
    maxHeight: DOC_VIEWER_DEFAULT_TRUNCATE_MAX_HEIGHT
  }),
  collapseButtonWrapper: (0, _react.css)({
    marginTop: -_uiTheme.euiThemeVars.euiSizeXS
  })
};