"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewTableRowBtnFilterExists = DocViewTableRowBtnFilterExists;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DocViewTableRowBtnFilterExists({
  onClick,
  disabled = false,
  scripted = false
}) {
  const tooltipContent = disabled ? scripted ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.docViews.table.unableToFilterForPresenceOfScriptedFieldsTooltip",
    defaultMessage: "Unable to filter for presence of scripted fields"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.docViews.table.unableToFilterForPresenceOfMetaFieldsTooltip",
    defaultMessage: "Unable to filter for presence of meta fields"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedDocViewer.docViews.table.filterForFieldPresentButtonTooltip",
    defaultMessage: "Filter for field present"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterForFieldPresentButtonAriaLabel', {
      defaultMessage: 'Filter for field present'
    }),
    onClick: onClick,
    className: "kbnDocViewer__actionButton",
    "data-test-subj": "addExistsFilterButton",
    disabled: disabled,
    iconType: 'filter',
    iconSize: 's'
  }));
}