"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightFieldDescription = HighlightFieldDescription;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function HighlightFieldDescription({
  fieldMetadata
}) {
  const {
    flat_name: fieldName,
    short,
    type
  } = fieldMetadata;
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, type && /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    type: type,
    size: "s"
  }), fieldName);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: title,
    content: short,
    color: "subdued"
  });
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = HighlightFieldDescription;