"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsOverviewHeader = LogsOverviewHeader;
exports.contentLabel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _timestamp = require("./sub_components/timestamp");
var _hover_popover_action = require("./sub_components/hover_popover_action");
var _log_level = require("./sub_components/log_level");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const contentLabel = exports.contentLabel = _i18n.i18n.translate('unifiedDocViewer.docView.logsOverview.label.content', {
  defaultMessage: 'Content breakdown'
});
function LogsOverviewHeader({
  doc,
  formattedDoc
}) {
  const hasLogLevel = Boolean(formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD]);
  const hasTimestamp = Boolean(formattedDoc[_discoverUtils.fieldConstants.TIMESTAMP_FIELD]);
  const {
    field,
    value,
    formattedValue
  } = (0, _discoverUtils.getMessageFieldWithFallbacks)(formattedDoc, {
    includeFormattedValue: true
  });
  const rawFieldValue = doc && field ? doc.flattened[field] : undefined;
  const messageCodeBlockProps = formattedValue ? {
    language: 'json',
    children: formattedValue
  } : {
    language: 'txt',
    dangerouslySetInnerHTML: {
      __html: value !== null && value !== void 0 ? value : ''
    }
  };
  const hasBadges = hasTimestamp || hasLogLevel;
  const hasMessageField = field && value;
  const hasFlyoutHeader = hasMessageField || hasBadges;
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: contentLabel
  });
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, contentLabel));
  const logLevelAndTimestamp = hasBadges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "m"
  }, formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD] && /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    value: formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD],
    field: _discoverUtils.fieldConstants.LOG_LEVEL_FIELD
  }, /*#__PURE__*/_react.default.createElement(_log_level.LogLevel, {
    level: formattedDoc[_discoverUtils.fieldConstants.LOG_LEVEL_FIELD]
  })), hasTimestamp && /*#__PURE__*/_react.default.createElement(_timestamp.Timestamp, {
    timestamp: formattedDoc[_discoverUtils.fieldConstants.TIMESTAMP_FIELD]
  }));
  const contentField = hasMessageField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "unifiedDocViewLogsOverviewMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, field), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, logLevelAndTimestamp)), /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    value: value,
    formattedValue: formattedValue,
    field: field,
    rawFieldValue: rawFieldValue,
    anchorPosition: "downCenter",
    display: "block"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, (0, _extends2.default)({
    overflowHeight: 100,
    paddingSize: "s",
    isCopyable: true,
    fontSize: "s"
  }, messageCodeBlockProps))));
  return hasFlyoutHeader ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: accordionTitle,
    paddingSize: "m",
    initialIsOpen: true,
    "data-test-subj": "unifiedDocViewLogsOverviewHeader"
  }, hasMessageField ? contentField : logLevelAndTimestamp) : null;
}