"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtDefaultTitle = exports.toastDrilldownsDeleted = exports.toastDrilldownsCRUDError = exports.toastDrilldownEdited = exports.toastDrilldownDeleted = exports.toastDrilldownCreated = exports.invalidDrilldownType = exports.insufficientLicenseLevel = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const toastDrilldownCreated = exports.toastDrilldownCreated = {
  title: drilldownName => _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownCreatedTitle', {
    defaultMessage: 'Drilldown "{drilldownName}" created',
    values: {
      drilldownName
    }
  }),
  text: _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownCreatedText', {
    // TODO: remove `Save your dashboard before testing.` part
    // when drilldowns are used not only in dashboard
    // or after https://github.com/elastic/kibana/issues/65179 implemented
    defaultMessage: 'Save your dashboard before testing.'
  })
};
const toastDrilldownEdited = exports.toastDrilldownEdited = {
  title: drilldownName => _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownEditedTitle', {
    defaultMessage: 'Drilldown "{drilldownName}" updated',
    values: {
      drilldownName
    }
  }),
  text: _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownEditedText', {
    defaultMessage: 'Save your dashboard before testing.'
  })
};
const toastDrilldownDeleted = exports.toastDrilldownDeleted = {
  title: _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownDeletedTitle', {
    defaultMessage: 'Drilldown deleted'
  }),
  text: _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownDeletedText', {
    defaultMessage: 'Save your dashboard before testing.'
  })
};
const toastDrilldownsDeleted = exports.toastDrilldownsDeleted = {
  title: n => _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownsDeletedTitle', {
    defaultMessage: '{n} drilldowns deleted',
    values: {
      n
    }
  }),
  text: _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownsDeletedText', {
    defaultMessage: 'Save your dashboard before testing.'
  })
};
const toastDrilldownsCRUDError = exports.toastDrilldownsCRUDError = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.toast.drilldownsCRUDErrorTitle', {
  defaultMessage: 'Error saving drilldown',
  description: 'Title for generic error toast when persisting drilldown updates failed'
});
const insufficientLicenseLevel = exports.insufficientLicenseLevel = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.insufficientLicenseLevelError', {
  defaultMessage: 'Insufficient license level',
  description: 'User created drilldown with higher license type, but then downgraded the license. This error is shown in the list near created drilldown'
});
const invalidDrilldownType = type => _i18n.i18n.translate('uiActionsEnhanced.drilldowns.components.flyoutDrilldownWizard.invalidDrilldownType', {
  defaultMessage: "Drilldown type {type} doesn't exist",
  values: {
    type
  }
});
exports.invalidDrilldownType = invalidDrilldownType;
const txtDefaultTitle = exports.txtDefaultTitle = _i18n.i18n.translate('uiActionsEnhanced.drilldowns.drilldownManager.state.defaultTitle', {
  defaultMessage: 'Drilldowns',
  description: 'Drilldowns flyout title.'
});