"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDrilldownManager = exports.DrilldownManagerProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _state = require("../../state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const context = /*#__PURE__*/_react.default.createContext(null);
const useDrilldownManager = () => _react.default.useContext(context);
exports.useDrilldownManager = useDrilldownManager;
const DrilldownManagerProvider = ({
  children,
  ...deps
}) => {
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const value = _react.default.useMemo(() => new _state.DrilldownManagerState(deps), []);
  return /*#__PURE__*/_react.default.createElement(context.Provider, {
    value: value
  }, children);
};
exports.DrilldownManagerProvider = DrilldownManagerProvider;