"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleStatusMessage = exports.getRuleHealthColor = exports.getOutcomeHealthColor = exports.getIsLicenseError = exports.getExecutionStatusHealthColor = void 0;
var _common = require("@kbn/alerting-plugin/common");
var _get_experimental_features = require("../get_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOutcomeHealthColor = status => {
  switch (status) {
    case 'succeeded':
      return 'success';
    case 'failed':
      return 'danger';
    case 'warning':
      return 'warning';
    default:
      return 'subdued';
  }
};
exports.getOutcomeHealthColor = getOutcomeHealthColor;
const getExecutionStatusHealthColor = status => {
  switch (status) {
    case 'active':
      return 'success';
    case 'error':
      return 'danger';
    case 'ok':
      return 'primary';
    case 'pending':
      return 'accent';
    case 'warning':
      return 'warning';
    default:
      return 'subdued';
  }
};
exports.getExecutionStatusHealthColor = getExecutionStatusHealthColor;
const getRuleHealthColor = rule => {
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  if (isRuleUsingExecutionStatus) {
    return getExecutionStatusHealthColor(rule.executionStatus.status);
  }
  return rule.lastRun && getOutcomeHealthColor(rule.lastRun.outcome) || 'subdued';
};
exports.getRuleHealthColor = getRuleHealthColor;
const getIsLicenseError = rule => {
  var _rule$lastRun, _rule$executionStatus;
  return ((_rule$lastRun = rule.lastRun) === null || _rule$lastRun === void 0 ? void 0 : _rule$lastRun.warning) === _common.RuleExecutionStatusErrorReasons.License || ((_rule$executionStatus = rule.executionStatus.error) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.reason) === _common.RuleExecutionStatusErrorReasons.License;
};
exports.getIsLicenseError = getIsLicenseError;
const getRuleStatusMessage = ({
  rule,
  licenseErrorText,
  lastOutcomeTranslations,
  executionStatusTranslations
}) => {
  const isLicenseError = getIsLicenseError(rule);
  const isRuleUsingExecutionStatus = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('ruleUseExecutionStatus');
  if (isLicenseError) {
    return licenseErrorText;
  }
  if (isRuleUsingExecutionStatus) {
    return executionStatusTranslations[rule.executionStatus.status];
  }
  return rule.lastRun && lastOutcomeTranslations[rule.lastRun.outcome];
};
exports.getRuleStatusMessage = getRuleStatusMessage;