"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _eui = require("@elastic/eui");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertItem = ({
  label,
  count,
  handleClick,
  alertType,
  color,
  showWarningIcon,
  'data-test-subj': dataTestSubj
}) => {
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    "data-test-subj": dataTestSubj,
    color: color
  }, (0, _numeral.default)(count).format(_constants.ALERT_COUNT_FORMAT), count > 0 && showWarningIcon ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    ascent: 10
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, label));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 50,
      wordWrap: 'break-word'
    },
    grow: false
  }, handleClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: event => {
      handleClick(event, alertType);
    }
  }, content) : content);
};
exports.AlertItem = AlertItem;