"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetQueryDelaySettings = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../../common/lib/kibana");
var _get_query_delay_settings = require("../lib/rule_api/get_query_delay_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetQueryDelaySettings = props => {
  const {
    enabled,
    onSuccess
  } = props;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const queryFn = () => {
    return (0, _get_query_delay_settings.getQueryDelaySettings)({
      http
    });
  };
  const {
    data,
    isFetching,
    isError,
    isLoadingError,
    isLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: ['getQueryDelaySettings'],
    queryFn,
    onSuccess,
    enabled,
    refetchOnWindowFocus: false,
    retry: false
  });
  return {
    isLoading: isLoading || isFetching,
    isError: isError || isLoadingError,
    data
  };
};
exports.useGetQueryDelaySettings = useGetQueryDelaySettings;