"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reauthorizeAndStartTransforms = reauthorizeAndStartTransforms;
var _transform = require("../../../../common/types/transform");
var _error_utils = require("../../utils/error_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function reauthorizeAndStartTransforms(transformsInfo, esClient, options) {
  const results = {};
  for (const transformInfo of transformsInfo) {
    const transformId = transformInfo.id;
    try {
      await esClient.transform.updateTransform({
        body: {},
        transform_id: transformId
      }, options !== null && options !== void 0 ? options : {});
      await esClient.transform.startTransform({
        transform_id: transformId
      }, {
        ignore: [409]
      });
      results[transformId] = {
        success: true
      };
    } catch (e) {
      if ((0, _error_utils.isRequestTimeout)(e)) {
        return (0, _error_utils.fillResultsWithTimeouts)({
          results,
          id: transformId,
          items: transformsInfo,
          action: _transform.TRANSFORM_ACTIONS.REAUTHORIZE
        });
      }
      results[transformId] = {
        success: false,
        error: e.meta.body.error
      };
    }
  }
  return results;
}