"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoute = registerRoute;
var _delete_transforms = require("../../api_schemas/delete_transforms");
var _constants = require("../../../../common/constants");
var _route_handler_factory = require("./route_handler_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoute(routeDependencies) {
  const {
    router,
    getLicense
  } = routeDependencies;
  /**
   * @apiGroup Transforms
   *
   * @api {post} /internal/transform/delete_transforms Post delete transforms
   * @apiName DeleteTransforms
   * @apiDescription Deletes transforms
   *
   * @apiSchema (body) deleteTransformsRequestSchema
   */
  router.versioned.post({
    path: (0, _constants.addInternalBasePath)('delete_transforms'),
    access: 'internal'
  }).addVersion({
    version: '1',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    },
    validate: {
      request: {
        body: _delete_transforms.deleteTransformsRequestSchema
      }
    }
  }, async (ctx, request, response) => {
    const license = await getLicense();
    return license.guardApiRoute((0, _route_handler_factory.routeHandlerFactory)(routeDependencies))(ctx, request, response);
  });
}