"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowStatsPane = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _transform_list = require("../../../../common/transform_list");
var _hooks = require("../../../../hooks");
var _expanded_row_column_view = require("./expanded_row_column_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoStatsFallbackTabContent = ({
  transformsStatsLoading
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const content = transformsStatsLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    iconType: "info",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.transformList.noStatsAvailable",
      defaultMessage: "No stats available for this transform."
    })
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    css: {
      height: euiTheme.size.xxxxl
    }
  }, content);
};
function getItemDescription(value) {
  if (typeof value === 'object') {
    return JSON.stringify(value);
  }
  return value.toString();
}
const ExpandedRowStatsPane = ({
  item
}) => {
  const {
    data: fullStats,
    isError,
    isLoading
  } = (0, _hooks.useGetTransformStats)(item.id, false, true);
  if (!(0, _transform_list.isTransformListRowWithStats)(item) && fullStats === undefined) {
    return /*#__PURE__*/_react.default.createElement(NoStatsFallbackTabContent, {
      transformsStatsLoading: isLoading
    });
  }
  let displayStats = {};
  if (fullStats !== undefined && !isLoading && !isError) {
    displayStats = fullStats.transforms[0].stats;
  } else if ((0, _transform_list.isTransformListRowWithStats)(item)) {
    var _item$stats;
    displayStats = (_item$stats = item.stats) === null || _item$stats === void 0 ? void 0 : _item$stats.stats;
  }
  const statsSection = {
    title: _i18n.i18n.translate('xpack.transform.transformList.transformDetails.statsTitle', {
      defaultMessage: 'Stats'
    }),
    items: Object.entries(displayStats).map(s => {
      return {
        title: s[0].toString(),
        description: getItemDescription(s[1])
      };
    }),
    position: 'left'
  };
  return /*#__PURE__*/_react.default.createElement(_expanded_row_column_view.ExpandedRowColumnView, {
    sections: [statsSection],
    showErrorCallout: isError,
    dataTestSubj: 'transformStatsTabContent'
  });
};
exports.ExpandedRowStatsPane = ExpandedRowStatsPane;